<?php
/**
 * Elementor Faq Widget.
 *
 * @since 1.1
 */

class Medic_Faq_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'faq';
	}

	public function get_title() {
		return __( 'FAQ', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-accordion';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label' => __( 'FAQ Section', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_subtitle',
			[
				'label' => __( 'Section Subtitle', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Subtitle', 'medic-extension' ),
				'default'  => __( "FAQ'S", 'medic-extension' )
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => __( 'Section Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( 'Frequently Asked Questions', 'medic-extension' )
			]
		);

		$this->add_control(
			'section_desc',
			[
				'label' => __( 'Section Description', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Description', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'accordion_img',
			[
				'label' => __( 'FAQ Image', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'accordion_featured_img',
			[
				'label' => __( 'FAQ Featured Image', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
				'show_label' => true
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'full',
				'separator' => 'none',
				'exclude' => [
					'full',
					'custom',
					'large',
					'shop_catalog',
					'shop_single',
					'shop_thumbnail'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'accordion_content',
			[
				'label' => __( 'FAQ Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'single_accordion_title', [
				'label' => __( 'Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'What can I expect at the first appointment?', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'single_accordion_content', [
				'label' => __( 'Description', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Description', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aut, beatae, similique vel officia laboriosam autem aperiam distinctio fugiat a repudiandae nihil quis nesciunt hic sit. Facere animi voluptate nobis asperiores quis nesciunt hic sit. Facere animi voluptate nobis ipsum dolor sit amet, consectetur adipisicing elit. Aut, beatae, similique vel officia laboriosam laboriosam autem aperiam distinctio fugiat.', 'medic-extension' )
			]
		);

		$this->add_control(
			'single_accordion',
			[
				'label' => __( 'Single FAQ', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Single FAQ #1', 'medic-extension' ),
						'list_content' => __( 'Single FAQ Content', 'medic-extension' ),
					],
				
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render Accordion widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.5
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

		<!-- START FAQ AREA -->
        <section class="faq-area ptb-70">
            <div class="container">
                <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                	<span class="top-title"><?php echo esc_html($settings['section_subtitle']); ?></span>
                    <h2><?php echo esc_html($settings['section_title']); ?></h2>
                    <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                </div>
				
                <div class="row align-items-center">
					<div class="col-lg-6">
                        <div data-aos="fade-up" data-aos-duration="1600" class="faq-image">
                            <?php if( $settings['accordion_featured_img']['url'] != '' ) : ?>  
                            	<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'accordion_featured_img' ); ?>
                            <?php endif; ?>
                        </div>
					</div>
					
                    <div class="col-lg-6">
                        <div class="faq-accordion">
                            <ul class="accordion">
                            	<?php foreach ( $settings['single_accordion'] as $item ) : ?>
	                                <li data-aos="fade-up" data-aos-duration="2000" class="accordion-item">
	                                    <a class="accordion-title" href="javascript:void(0)">
	                                        <i class="bx bx-plus"></i>
	                                        <?php echo wp_kses_post($item['single_accordion_title']); ?>
	                                    </a>
	                                    <p class="accordion-content">
	                                        <?php echo wp_kses_post($item['single_accordion_content']); ?>
	                                    </p>
	                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
		</section>
		<!-- END FAQ AREA -->

    <?php 

    }

}
