<?php

/**
 * Elementor Slider Widget.
 *
 * @since 1.1
 */

class Medic_Slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'slider';
	}

	public function get_title() {
		return __( 'Slider', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'slider_content',
            [
                'label' => esc_html__( 'Slider Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'slider_subtitle',
            [
                'label' => __( 'Slider Subtitle', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Subtitle', 'medic-extension' ),
                'default'  => __( 'Welcome To Medic', 'medic-extension' )
            ]
        );

        $repeater->add_control(
            'slider_title',
            [
                'label' => __( 'Slider Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Specializing Cosmetic Medical Surgery', 'medic-extension' )
            ]
        );

        $repeater->add_control(
            'slider_desc',
            [
                'label' => __( 'Slider Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default'  => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Nihil architecto laborum eaque! Deserunt maxime, minus quas molestiae reiciendis.', 'medic-extension' )
            ]
        );

        $repeater->add_control(
            'slider_image',
            [
                'label' => __( 'Slider Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $repeater->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button Text', 'medic-extension' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __('Book An Appointment', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'btn_link_type',
            [
                'label'         => esc_html__( 'Button Link Type', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options' => [
                    '1'     => esc_html__( 'Link To Page', 'medic-extension' ),
                    '2'     => esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'btn_link_to_page',
            [
                'label'         => esc_html__( 'Button Link Page', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options'       => medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $repeater->add_control(
            'btn_ex_link',
            [
                'label'     => esc_html__('Button External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'slider',
            [
                'label' => __( 'Slider', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Slider #1', 'medic-extension' ),
                        'list_content' => __( 'Slider Content', 'medic-extension' )
                    ]
                ]
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <!-- START HERO SLIDER AREA -->
        <section class="hero-slider-area">
            <div class="hero-slider-wrap owl-carousel owl-theme">
                <?php foreach (  $settings['slider'] as $item ) { 
                    if($item['btn_link_type'] == '2') : 
                        $target = $item['btn_ex_link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $item['btn_ex_link']['nofollow'] ? ' rel="nofollow"' : ''; 
                    elseif($item['btn_link_type'] == '1') : 
                        $target = '';
                        $nofollow = '';
                    endif; 

                    // Get Button Link
                    if($item['btn_link_type'] == 1) {
                        $btn_link = get_page_link( $item['btn_link_to_page'] );
                    } else {
                        $btn_link = $item['btn_ex_link']['url'];
                    } ?>

                <div class="slider-item" style="background-image: url(<?php echo esc_url( $item['slider_image']['url'] ); ?>)">
                    <div class="d-table">
                        <div class="d-table-cell">
                            <div class="container">
                                <div class="slider-text one">
                                    <span class="top-title"><?php echo esc_attr($item['slider_subtitle']); ?></span>
                                    <h1><?php echo esc_attr($item['slider_title']); ?></h1>
                                    <p><?php echo wp_kses_post($item['slider_desc']); ?></p>

                                    <div class="slider-btn">
                                        <!-- Button Part Start --> 
                                        <?php if( $item['show_btn'] == 'yes' && $item['button_text'] != '' ): ?>
                                            <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $item['button_text'] ); ?></a>
                                        <?php endif; ?>
                                        <!-- Button Part End -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </section>
        <!-- END HERO SLIDER AREA -->

        <?php

    }

}
