<?php

/**
 * Elementor Testimonial Widget.
 *
 * @since 1.1
 */

class Medic_Testimonial_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'testimonial';
	}

	public function get_title() {
		return __( 'Testimonial', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-testimonial';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_section',
			[
				'label' => __( 'Testimonial Section', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'section_subtitle',
			[
				'label' => __( 'Section Subtitle', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Subtitle', 'medic-extension' ),
				'default'  => __( 'Testimonials', 'medic-extension' )
			]
		);

	    $this->add_control(
			'section_title',
			[
				'label' => __( 'Section Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( 'What Our Client’s Say', 'medic-extension' )
			]
		);

		$this->add_control(
			'section_desc',
			[
				'label' => __( 'Section Description', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Description', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_content',
			[
				'label' => __( 'Testimonial Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'select_testimonial_style',
			[
				'label' => __( 'Testimonial Style', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'grid' => __( 'Grid', 'medic-extension' ),
					'slider' => __( 'Slider', 'medic-extension' )
				],
				'default' => 'slider'
			]
		);

		$this->add_control(
			'testimonial_item_column',
			[
				'label' => __( 'Testimonial Column', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'columns-2' => __( '2', 'medic-extension' ),
					'columns-3' => __( '3', 'medic-extension' ),
					'columns-4' => __( '4', 'medic-extension' )
				],
				'default' => 'columns-2',
				'condition' => [
                    'select_testimonial_style' => 'grid'
                ]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'single_testimonial_img', [
				'label' => __( 'Image', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
				'show_label' => true
			]
		);

		$repeater->add_control(
			'single_testimonial_name', [
				'label' => __( 'Name', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( 'William Robart', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'single_testimonial_position', [
				'label' => __( 'Designation', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Designation', 'medic-extension' ),
				'default'  => __( 'Consulting Doctor', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'single_testimonial_comment',
			[
				'label' => __( 'Comment', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Comment', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem Ipsum is simply dummy text of the printing and Quis suspendisse typesetting ipsum dolor sit amet, consectetur.', 'medic-extension')
			]
		);

		$this->add_control(
			'single_testimonial',
			[
				'label' => __( 'Single Testimonial', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Single Testimonial #1', 'medic-extension' ),
						'list_content' => __( 'Single Testimonial Content', 'medic-extension' )
					]
				]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <!-- Testimonial Column Style -->
        <?php if($settings['select_testimonial_style'] == 'grid') :
		    if( $settings['testimonial_item_column'] == 'columns-2' ) :
				$testimonial_column = 'col-lg-6 col-md-6 col-sm-12';
			elseif( $settings['testimonial_item_column'] == 'columns-3' ) :
				$testimonial_column = 'col-lg-4 col-md-6 col-sm-12';
			elseif( $settings['testimonial_item_column'] == 'columns-4' ) :
				$testimonial_column = 'col-lg-3 col-md-6 col-sm-12';
			endif;
		endif; ?>

        <!-- START TESTIMONIALS AREA -->
        <?php if($settings['select_testimonial_style'] == 'grid') : ?>
    	    <section class="testimonial-page ptb-70">
    	<?php elseif($settings['select_testimonial_style'] == 'slider') : ?>
    	    <section class="testimonial-area ptb-70">
        <?php endif; ?>
            <div class="container">
                <div class="section-title">
                	<span class="top-title"><?php echo esc_html($settings['section_subtitle']); ?></span>
                    <h2><?php echo esc_html($settings['section_title']); ?></h2>
                    <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                </div>
                <?php if($settings['select_testimonial_style'] == 'grid') : ?>
            	    <div class="row justify-content-center">
            	<?php elseif($settings['select_testimonial_style'] == 'slider') : ?>
            	    <div class="testimonial-wrap owl-carousel owl-theme">
                <?php endif; ?>
                	<?php foreach ( $settings['single_testimonial'] as $item ) : ?>
                		<?php if($settings['select_testimonial_style'] == 'grid') : ?>
	                	    <div class="<?php echo esc_attr( $testimonial_column ); ?>">
	                	<?php elseif($settings['select_testimonial_style'] == 'slider') : ?>
	                	    <div>
	                    <?php endif; ?>
	                        <div class="single-testimonial">
	                        	<?php if( ! $item['single_testimonial_img']['url'] == '' ) : ?>
	                                <img src="<?php echo esc_url( $item['single_testimonial_img']['url'] ); ?>" alt="image">
                                <?php endif; ?>
	                			<p class="comment"><?php echo wp_kses_post($item['single_testimonial_comment']); ?></p>
	                			<h3>
			                        <?php echo esc_html($item['single_testimonial_name']); ?>
			                    </h3>
			                    <span class="designation">
			                        <?php echo esc_html($item['single_testimonial_position']); ?>
			                    </span>
	                        </div>
	                	</div>			       
                    <?php endforeach; ?>			               
                </div>
            </div>
        </div>
	    <!-- End TESTIMONIALS AREA -->

    <?php

	}

}
