<?php

add_action( 'add_meta_boxes', 'medic_extension_custom_meta_box_page' );

if( ! function_exists('medic_extension_custom_meta_box_page') ) :

    function medic_extension_custom_meta_box_page($post){
        add_meta_box('add_meta_box_single_page', __('Select Sidebar', 'medic-extension'), 'medic_extension_custom_element_grid_class_meta_box_single_page', 'page', 'normal' , 'high');
    }

endif;

add_action('save_post', 'medic_extension_save_metabox_page');

if( ! function_exists('medic_extension_save_metabox_page') ) :

    function medic_extension_save_metabox_page(){ 
        global $post;
        if(isset($_POST["custom_element_grid_class_single_page"])){
            $meta_element_class_single_page = sanitize_text_field($_POST['custom_element_grid_class_single_page']);
            update_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_page', $meta_element_class_single_page);
        }
    }

endif;

function medic_extension_custom_element_grid_class_meta_box_single_page($post){
    $meta_element_class_single_page = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_page', true); ?>   
    <label><?php echo esc_html__('Choose the type of the page : ', 'medic-extension'); ?></label>
    <select name="custom_element_grid_class_single_page" id="custom_element_grid_class_single_page">
        <option value="no-sidebar" <?php selected( $meta_element_class_single_page, 'no-sidebar' ); ?>><?php echo esc_html__('No Sidebar', 'medic-extension'); ?></option>
        <option value="left-sidebar" <?php selected( $meta_element_class_single_page, 'left-sidebar' ); ?>><?php echo esc_html__('Left Sidebar', 'medic-extension'); ?></option>
        <option value="right-sidebar" <?php selected( $meta_element_class_single_page, 'right-sidebar' ); ?>><?php echo esc_html__('Right Sidebar', 'medic-extension'); ?></option>
    </select>
  <?php
}
