# [Unyson](https://wordpress.org/plugins/unyson/) Framework [ ![Download](https://rawgit.com/ThemeFuse/Unyson/master/.github/img/download-stable-version.svg) ](https://github.com/ThemeFuse/Unyson/releases/latest)

[Unyson](http://unyson.io/) is a framework for [WordPress](http://wordpress.org/) that facilitates the development of a theme.

This framework was created from the ground up by the team behind [ThemeFuse](http://themefuse.com/) from the desire to empower developers to build outstanding WordPress themes fast and easy.

## Table of contents

* [Installation](#installation).
* [Documentation](#documentation).
* [Extensions](#extensions).
* [Contributing](#contributing).
* [Bug reports](#bug-reports).
* [Copyright and license](#copyright-and-license).

## Installation

1. Open the WordPress dashboard **Plugins > Add New** menu.
2. Type **Unyson** in the search field.
3. Press the **Install** button and **activate** the plugin.
4. Configure the plugin by going to the **Unyson menu**.

## Documentation

Unyson's documentation is available on http://manual.unyson.io/.

You can help us improve the documentation by contributing to this [Github repository](https://github.com/ThemeFuse/Unyson-Documentation).

## Extensions

If you have a bug report or feature request related to a specific extension, follow one of the links below:

* [Page Builder](https://github.com/ThemeFuse/Unyson-PageBuilder-Extension)
* [WordPress Shortcodes](https://github.com/ThemeFuse/Unyson-WP-Shortcodes-Extension)
* [Shortcodes](https://github.com/ThemeFuse/Unyson-Shortcodes-Extension)
* [Mega Menu](https://github.com/ThemeFuse/Unyson-MegaMenu-Extension)
* [Sidebars](https://github.com/ThemeFuse/Unyson-Sidebars-Extension)
* [Sliders](https://github.com/ThemeFuse/Unyson-Sliders-Extension)
* [Portfolio](https://github.com/ThemeFuse/Unyson-Portfolio-Extension)
* [Backup & Demo Content](https://github.com/ThemeFuse/Unyson-Backups-Extension)
* [SEO](https://github.com/ThemeFuse/Unyson-SEO-Extension)
* [Forms](https://github.com/ThemeFuse/Unyson-Forms-Extension)
* [Feedback](https://github.com/ThemeFuse/Unyson-Feedback-Extension)
* [Breadcrumbs](https://github.com/ThemeFuse/Unyson-Breadcrumbs-Extension)
* [Events](https://github.com/ThemeFuse/Unyson-Events-Extension)
* [Update](https://github.com/ThemeFuse/Unyson-Update-Extension)
* [Analytics](https://github.com/ThemeFuse/Unyson-Analytics-Extension)
* [Builder](https://github.com/ThemeFuse/Unyson-Builder-Extension)
* [Mailer](https://github.com/ThemeFuse/Unyson-Mailer-Extension)
* [Social](https://github.com/ThemeFuse/Unyson-Social-Extension)
* [Population Methods](https://github.com/ThemeFuse/Unyson-PopulationMethods-Extension)
* [Blog Posts](https://github.com/ThemeFuse/Unyson-Blog-Extension)
* [Learning](https://github.com/ThemeFuse/Unyson-Learning-Extension)
* [Translation](https://github.com/ThemeFuse/Unyson-Translation-Extension)

## Contributing

You can contribute with:

* **Source code**, via Pull Requests. Please read our [contributor guidelines](https://github.com/ThemeFuse/Unyson/blob/master/CONTRIBUTING.md).
* **Translations**, through [Transifex](https://www.transifex.com/projects/p/unyson/).

If you have themes built with Unyson, **test the compatibility with new extensions updates** before they are going to be released on [Unyson Extensions Approval](https://github.com/ThemeFuse/Unyson-Extensions-Approval).

## Bug reports

We strive to make Unyson Development  to be awesome and user friendly, though sometimes it's impossible to avoid bugs.
A bug means "something is broken" or is not working as it should.

In order to offer you an effective support and fix for an issue, please follow the below guidelines before submitting a bug report:

#### Explore Known Issues

Has your issue already been reported? Check the [Issues page](https://github.com/ThemeFuse/Unyson/issues).

If your issue has already been reported, great! It will be reviewed in an upcoming release.

#### Submitting a Bug Report

You can report the issue via [Issues page](https://github.com/ThemeFuse/Unyson/issues).
A good bug report includes full details to easily understand the issue you are having and the exact steps to reproduce if it is a bug.

## Copyright and license

Code and documentation copyright 2014 ThemeFuse LTD. Code released under [the GPL license](https://github.com/ThemeFuse/Unyson/blob/master/framework/LICENSE). Docs released under [Creative Commons](https://github.com/ThemeFuse/Unyson-Documentation/blob/master/LICENSE).

[![PhpStorm IDE](https://rawgit.com/ThemeFuse/Unyson/master/.github/img/phpstorm.png)](https://www.jetbrains.com/phpstorm/)
[![Build Status](https://travis-ci.org/ThemeFuse/Unyson.svg?branch=master)](https://travis-ci.org/ThemeFuse/Unyson)
