<?php
/**
 * Medic functions and definitions
 *
 * @package Medic
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.1' );
}

if ( ! function_exists( 'medic_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function medic_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Medic, use a find and replace
		 * to change 'medic' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'medic', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'medic-primary-menu' => esc_html__( 'Primary', 'medic' )
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		/*add_theme_support(
			'custom-background',
			apply_filters(
				'medic_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);*/

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'medic_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function medic_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'medic_content_width', 640 );
}
add_action( 'after_setup_theme', 'medic_content_width', 0 );

/**
 * Register widget area.
 *
 */
function medic_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Page Sidebar', 'medic' ),
			'id'            => 'page-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog Sidebar', 'medic' ),
			'id'            => 'blog-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Department Sidebar', 'medic' ),
			'id'            => 'department-sidebar',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer First Block', 'medic' ),
			'id'            => 'footer-first-block',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Second Block', 'medic' ),
			'id'            => 'footer-second-block',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Third Block', 'medic' ),
			'id'            => 'footer-third-block',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Forth Block', 'medic' ),
			'id'            => 'footer-forth-block',
			'description'   => esc_html__( 'Add widgets here.', 'medic' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'medic_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function medic_scripts() {
	wp_enqueue_style( 'medic-font-1', get_template_directory_uri() . '/assets/css/medic-font-1.css', array(), '1.1' );

	wp_enqueue_style( 'medic-font-2', get_template_directory_uri() . '/assets/css/medic-font-2.css', array(), '1.1' );

	wp_enqueue_style( 'medic-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-owl-theme-default', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-animate', get_template_directory_uri() . '/assets/css/animate.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-boxicons', get_template_directory_uri() . '/assets/css/boxicons.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-flaticon', get_template_directory_uri() . '/assets/css/flaticon.css', array(), '1.1' );

	wp_enqueue_style( 'medic-meanmenu', get_template_directory_uri() . '/assets/css/meanmenu.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-nice-select', get_template_directory_uri() . '/assets/css/nice-select.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-odometer', get_template_directory_uri() . '/assets/css/odometer.min.css', array(), '1.1' );

	wp_enqueue_style( 'medic-aos', get_template_directory_uri() . '/assets/css/aos.css', array(), '1.1' );

	wp_enqueue_style( 'medic-main', get_template_directory_uri() . '/assets/css/main.css', array(), '1.1' );

	if ( ! is_child_theme() ) {
	    wp_enqueue_style( 'medic-style', get_stylesheet_uri(), array(), '1.1' );
	    wp_style_add_data( 'medic-style', 'rtl', 'replace' );
    }

	wp_enqueue_style( 'medic-responsive', get_template_directory_uri() . '/assets/css/responsive.css', array(), '1.1' );

	wp_enqueue_script( 'jquery' );

	wp_enqueue_script( 'medic-bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-meanmenu', get_template_directory_uri() . '/assets/js/meanmenu.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-wow', get_template_directory_uri() . '/assets/js/wow.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-magnific-popup', get_template_directory_uri() . '/assets/js/magnific-popup.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-nice-select', get_template_directory_uri() . '/assets/js/nice-select.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-appear', get_template_directory_uri() . '/assets/js/appear.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-odometer', get_template_directory_uri() . '/assets/js/odometer.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-bootstrap-datepicker', get_template_directory_uri() . '/assets/js/bootstrap-datepicker.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-form-validator', get_template_directory_uri() . '/assets/js/form-validator.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-ajaxchimp', get_template_directory_uri() . '/assets/js/ajaxchimp.min.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-aos', get_template_directory_uri() . '/assets/js/aos.js', array(), '1.1', true );

	wp_enqueue_script( 'medic-custom', get_template_directory_uri() . '/assets/js/custom.js', array(), '1.1', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'medic_scripts' );

/**
 * Post Content Excerpt
 */
function medic_blog_read_more( $num = 10 ) {
	$excerpt = get_the_excerpt();
	$trimmed_content = wp_trim_words( $excerpt, $num_words = $num, $more = null );
	echo wp_kses( $trimmed_content );
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Bootstrap navwalker.
 */
require get_template_directory() . '/inc/navwalker.php';

/**
 * Custom Style & Script.
 */
require get_template_directory() . '/inc/custom-style-script.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

/**
 * Load required & recommended plugins.
 */
require get_template_directory() . '/inc/tgmpa/init.php';

/**
 * Include redux options.
 */
require get_template_directory() . '/inc/options-config.php';

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Include review file.
 */
require get_template_directory() . '/inc/review.php';

/**
 * Include unyson extension function.
 */
if ( ! function_exists( '_mwt_fw_filter_github_api_url' ) ) :
	function _mwt_fw_filter_github_api_url( $url ) {
		return 'https://api.github.com';
	}
endif;

add_filter( 'fw_github_api_url', '_mwt_fw_filter_github_api_url', 999 );
