<?php
/**
 * The header for our theme
 *
 * @package Medic
 */

?>
<?php global $medic; ?>
<!doctype html>
<?php if( isset($medic['website-default-layout']) && $medic['website-default-layout'] == 1 ) : ?>
    <html <?php language_attributes(); ?>>
<?php elseif( isset($medic['website-default-layout']) && $medic['website-default-layout'] == 2 ) : ?>
    <html dir="rtl" <?php language_attributes(); ?>>
<?php endif; ?>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'medic' ); ?></a>
    
    <?php get_template_part( 'template-parts/content', 'header' );
