<?php
/**
 *
 * @see http://tgmpluginactivation.com/configuration/
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Medic
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/inc/tgmpa/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'medic_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 */
function medic_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		array(
			'name'               => 'Medic Extension',
			'slug'               => 'medic-extension',
			'source'             => get_template_directory() . '/inc/tgmpa/plugins/medic-extension.zip',
			'required'           => true,
			'version'            => '',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => ''
		),
		
		array(
			'name'               => 'Unyson',
			'slug'               => 'unyson',
			'source'             => 'https://github.com/ThemeFuse/Unyson/archive/refs/heads/master.zip', 
			'required'           => true, 
			'version'            => '',
			'force_activation'   => false, 
			'force_deactivation' => false,
			'external_url'       => '', 
			'is_callable'        => ''
		),

		array(
			'name'      => 'Redux Framework',
			'slug'      => 'redux-framework',
			'required'  => true
		),

		array(
			'name'      => 'Elementor Website Builder',
			'slug'      => 'elementor',
			'required'  => true
		),

		array(
			'name'      => 'WooCommerce',
			'slug'      => 'woocommerce',
			'required'  => false
		),

		array(
			'name'      => 'MC4WP: Mailchimp for WordPress',
			'slug'      => 'mailchimp-for-wp',
			'required'  => false
		),

		array(
			'name'      => 'Contact form 7',
			'slug'      => 'contact-form-7',
			'required'  => false
		),

		array(
			'name'      => 'Appointment Hour Booking',
			'slug'      => 'appointment-hour-booking',
			'required'  => false
		)

	);

	/*
	 * Array of configuration settings. Amend each line as needed.
	 */
	$config = array(
		'id'           => 'medic',          
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'parent_slug'  => 'themes.php',
		'capability'   => 'edit_theme_options',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => ''
	);

	tgmpa( $plugins, $config );
}
