<?php
/**
 * Template part for displaying post details
 *
 * @package Medic
 */

global $medic; global $post;
$medic_single_department_sidebar = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_department', true); ?>

<!-- START PAGE TITLE AREA -->
<div class="page-title-area">
	<div class="container">
		<div class="page-title-content">
			<h2><?php single_post_title(); ?></h2>
			<ul>
				<li>
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<?php echo esc_html('Home', 'medic'); ?>
					</a>
				</li>
				<li class="active"><?php single_post_title(); ?></li>
			</ul>
		</div>
	</div>
</div>
<!-- END PAGE TITLE AREA -->

<!-- START BLOG DETAILS AREA -->
<section class="blog-details-area ptb-70">
	<div class="container">
		<div class="row">
			<?php if( $medic_single_department_sidebar == '' || $medic_single_department_sidebar == 'left-sidebar' ) : ?>
				<div data-aos="fade-up" data-aos-duration="800" class="col-lg-4">
					<div class="blog-details-right-area blog-left-sidebar">
						<?php dynamic_sidebar('department-sidebar'); ?>
					</div>
				</div>
		    <?php endif; ?>

		    <?php if( $medic_single_department_sidebar == 'no-sidebar' ) : ?>
                <div class="col-lg-12 full-width">
            <?php elseif( $medic_single_department_sidebar == '' || $medic_single_department_sidebar == 'left-sidebar' || $medic_single_department_sidebar == 'right-sidebar'  ) : ?>
                <div class="col-lg-8">        
            <?php endif; ?>
				<div class="blog-details-left-area">
					<div data-aos="fade-up" data-aos-duration="1200" class="blog-details-single-post">
						<div class="blog-details-img">
							<?php the_post_thumbnail(); ?> 
						</div>

						<h3><?php the_title(); ?></h3>

						<?php the_content(); ?>

					</div>
				</div>
			</div>
			
            <?php if( $medic_single_department_sidebar == 'right-sidebar' ) : ?>
				<div data-aos="fade-up" data-aos-duration="1600" class="col-lg-4">
					<div class="blog-details-right-area blog-right-sidebar">
						<?php dynamic_sidebar('department-sidebar'); ?>
					</div>
				</div>
		    <?php endif; ?>
		</div>
	</div>
</section>
<!-- END BLOG DETAILS AREA -->
