<?php global $medic;

if( isset($medic['show-newsletter']) && $medic['show-newsletter'] == 1 ) : ?>
	<!-- START SUBSCRIBE AREA -->
	<section class="subscribe-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<h2><?php echo esc_html( $medic['newsletter-title'] ); ?></h2>
					<p><?php echo wp_kses_post( $medic['newsletter-desc'] ); ?></p>
				</div>

				<div class="col-lg-6">
					<?php if(isset($medic['newsletter-shortcode']) && $medic['newsletter-shortcode'] != '') :
					    echo do_shortcode($medic['newsletter-shortcode']);
					endif; ?>
				</div>
			</div>
		</div>
	</section>
	<!-- END SUBSCRIBE AREA  -->
<?php endif; ?>

<!-- START FOOTER TOP AREA -->
<footer class="footer-top-area pt-100 pb-70">
	<div class="container">
		<div class="row">
			<div class="col-lg-3 col-md-6">
			  <?php dynamic_sidebar('footer-first-block'); ?>
			</div>
			<div class="col-lg-3 col-md-6">
			  <?php dynamic_sidebar('footer-second-block'); ?>
			</div>
			<div class="col-lg-3 col-md-6">
			  <?php dynamic_sidebar('footer-third-block'); ?>
			</div>
			<div class="col-lg-3 col-md-6">
			  <?php dynamic_sidebar('footer-forth-block'); ?>
			</div>
		</div>
	</div>
</footer>
<!-- END FOOTER TOP AREA -->

<!-- START FOOTER BOTTOM AREA -->
<footer class="footer-bottom-area">
	<div class="container">
		<div class="copy-right">
			<?php if(isset($medic['copyright-text']) && $medic['copyright-text'] != '') : ?>
				<?php if(isset($medic['show-automatic-year']) && $medic['show-automatic-year'] == true) : ?>
                    <p>© <?php echo date('Y '); ?><?php echo wp_kses_post($medic['copyright-text']); ?></p>
                <?php elseif(isset($medic['show-automatic-year']) && $medic['show-automatic-year'] == false) : ?>
                    <p><?php echo wp_kses_post($medic['copyright-text']); ?></p>
                <?php endif; ?>
            <?php endif; ?>
		</div>
	</div>
</footer>
<!-- END FOOTER BOTTOM AREA -->

<!-- START GO TOP AREA -->
<div class="go-top">
	<i class='bx bx-chevrons-up'></i>
</div>
<!-- END GO TOP AREA -->

<?php if( isset($medic['ltr-rtl-btn-show-hide']) && $medic['ltr-rtl-btn-show-hide'] == 1 ) : ?>
	<!-- Start LTR & RTL Button -->
	<div class="ltr-rtl-button">
		<a class="medic-default-btn active ltr">
		    <?php echo esc_html( $medic['ltr-btn-text'] ); ?>
		</a>
		<a class="medic-default-btn rtl">
		    <?php echo esc_html( $medic['rtl-btn-text'] ); ?>
		</a>
	</div>
	<!-- End LTR & RTL Button -->
<?php endif; ?>
		