<?php global $medic; ?>

<?php if( isset($medic['preloader-show-hide']) && $medic['preloader-show-hide'] == 1 ) : ?>
	<!-- START PRELOADER AREA -->
	<div class="preloader">
		<div class="lds-ripple">
			<div></div>
			<div></div>
		</div>
	</div>
	<!-- END PRELOADER AREA -->
<?php endif; ?>

<!-- START HEADER AREA --> 
<header class="header-area">
	<?php if( isset($medic['top-bar-show-hide']) && $medic['top-bar-show-hide'] == 1 ) : ?>
		<div class="top-header-area">
			<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-6">
						<ul class="heading-left-part">
							<?php if( $medic['phone'] ) : ?>
								<li>
									<i class="bx bx-phone-call"></i>
									<span><?php echo esc_html( $medic['phone-title'] ); ?></span>
									<a href="tel:<?php echo esc_html( $medic['phone'] ); ?>"><?php echo esc_html( $medic['phone'] ); ?></a>
								</li>
							<?php endif; ?>
							<?php if( $medic['email'] ) : ?>
								<li>
									<i class="bx bx-envelope"></i>
									<span><?php echo esc_html( $medic['email-title'] ); ?></span>
									<a href="mailto:<?php echo esc_html( $medic['email'] ); ?>"><?php echo esc_html( $medic['email'] ); ?></a>
								</li>
							<?php endif; ?>
						</ul>
					</div>
                    <?php if( isset($medic['header-social']) && $medic['header-social'] == 1 ) : ?>
						<div class="col-lg-6">
							<ul class="heading-right-part">
								<?php if ( isset($medic['social-links']['1']) && $medic['social-links']['1'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['1'] ); ?>"><i class="bx bxl-facebook"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['2']) && $medic['social-links']['2'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['2'] ); ?>"><i class="bx bxl-twitter"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['3']) && $medic['social-links']['3'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['3'] ); ?>"><i class="bx bxl-youtube"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['4']) && $medic['social-links']['4'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['4'] ); ?>"><i class="bx bxl-linkedin"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['5']) && $medic['social-links']['5'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['5'] ); ?>"><i class="bx bxl-skype"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['6']) && $medic['social-links']['6'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['6'] ); ?>"><i class="bx bxl-instagram"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['7']) && $medic['social-links']['7'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['7'] ); ?>"><i class="bx bxl-pinterest"></i></a></li>
                                <?php endif; ?>
                                <?php if ( isset($medic['social-links']['8']) && $medic['social-links']['8'] ) : ?>
                                    <li><a href="<?php echo esc_html( $medic['social-links']['8'] ); ?>"><i class="bx bxl-google-plus"></i></a></li>
                                <?php endif; ?>
							</ul>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endif; ?>
	<div class="nav-area">
		<div class="navbar-area">
			<div class="main-nav">
				<nav class="navbar navbar-expand-md">
					<div class="container">
						<?php if( has_custom_logo() ) : ?>
							<div class="navbar-brand">
						        <?php the_custom_logo(); ?>
						    </div>
						<?php else: ?>
							<div class="site-branding">
                                <?php
                                if ( is_front_page() && is_home() ) :
                                    ?>
                                    <h3 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h3>
                                    <?php
                                else :
                                    ?>
                                    <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                                    <?php
                                endif;
                                $medic_description = get_bloginfo( 'description', 'display' );
                                if ( $medic_description || is_customize_preview() ) :
                                    ?>
                                    <p class="site-description"><?php echo esc_html( $medic_description ); /* WPCS: xss ok. */ ?></p>
                                <?php endif; ?>
                            </div><!-- .site-branding -->
						<?php endif; ?>
						<div class="collapse navbar-collapse mean-menu">
							<?php
                                $primary_nav_arg = [
                                    'theme_location'  => 'medic-primary-menu',
                                    'container'       => null,
                                    'menu_class'      => 'navbar-nav m-auto',
                                    'depth'           => 3,
                                    'walker'          => new Medic_Bootstrap_Navwalker(),
                                    'fallback_cb'     => 'Medic_Bootstrap_Navwalker::fallback'
                                ];
                                if( has_nav_menu( 'medic-primary-menu' ) ) :
                                    wp_nav_menu( $primary_nav_arg );
                                else: 
                                    if( is_user_logged_in() ) {
                                    echo wp_kses_post( '<ul class="navbar-nav m-auto"><li class="nav-item"><a href="'.esc_url(home_url('/')).'/wp-admin/nav-menus.php">Create a menu</a></li></ul>', 'medic' );
                                    }
                                    else{
                                    echo wp_kses_post( '<ul class="navbar-nav m-auto"><li class="nav-item"><a href="'.esc_url(home_url('/')).'">Home</a></li></ul>', 'medic' );
                                    }
                                endif;
                            ?>

							<?php if( isset($medic['get-button-text']) && $medic['get-button-text'] != '' ) : ?>
								<!-- Start Other Option -->
								<div class="others-option">
									<div class="get-quote">
		                                <div class="navbar_btn">
		                                    <a href="<?php echo esc_url( $medic['get-button-link'] ); ?>" class="medic-default-btn">
		                                        <?php echo esc_html( $medic['get-button-text'] ); ?>
		                                    </a>
		                                </div>
									</div>
								</div>
								<!-- End Other Option -->
							<?php endif; ?>
						</div>
					</div>
				</nav>
			</div>

			<!-- Menu For Mobile Device -->
			<div class="mobile-nav">
				<?php 
				if( has_custom_logo() ) : ?>
					<div class="logo">
					    <?php the_custom_logo(); ?>
					</div>
				<?php else: ?>
					<div class="site-branding">
                        <?php
                        if ( is_front_page() && is_home() ) :
                            ?>
                            <h3 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h3>
                            <?php
                        else :
                            ?>
                            <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                            <?php
                        endif;
                        $medic_description = get_bloginfo( 'description', 'display' );
                        if ( $medic_description || is_customize_preview() ) :
                            ?>
                            <p class="site-description"><?php echo esc_html( '- '.$medic_description ); /* WPCS: xss ok. */ ?></p>
                        <?php endif; ?>
                    </div><!-- .site-branding -->
				<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</header>
<!-- END HEADER AREA -->
