<?php
/**
 * Template part for displaying page content in page.php
 *
 * @package Medic
 */

global $medic; global $post;
$medic_single_page_sidebar = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_page', true); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
	<?php if ( ! is_home() && ! is_front_page() ) : ?>
		<!-- START PAGE TITLE AREA -->
		<div class="page-title-area">
			<div class="container">
				<div class="page-title-content">
					<h2><?php single_post_title(); ?></h2>
					<ul>
						<li>
							<a href="<?php echo esc_url(home_url('/')); ?>">
								<?php echo esc_html('Home', 'medic'); ?>
							</a>
						</li>
						<li class="active"><?php single_post_title(); ?></li>
					</ul>
				</div>
			</div>
		</div>
		<!-- END PAGE TITLE AREA -->
    <?php endif; ?>

    <div class="entry-content">

	    <div class="container">

		    <div class="row">
	            
	            <?php if( $medic_single_page_sidebar == 'left-sidebar' ) : ?>
			    	<div data-aos="fade-up" data-aos-duration="800" class="col-lg-4">
			    		<div class="blog-details-right-area blog-left-sidebar">
							<?php dynamic_sidebar('page-sidebar'); ?>
						</div>
			    	</div>
		    	<?php endif; ?>

		    	<?php if( $medic_single_page_sidebar == '' || $medic_single_page_sidebar == 'no-sidebar' ) : ?>
	                <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-12 full-width">
	            <?php elseif( $medic_single_page_sidebar == 'left-sidebar' || $medic_single_page_sidebar == 'right-sidebar'  ) : ?>
	                <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-8">        
	            <?php endif; ?>

					<?php medic_post_thumbnail(); ?>

					
						<?php
						the_content();

						wp_link_pages(
							array(
								'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'medic' ),
								'after'  => '</div>',
							)
						);
						?>

				</div>
	            
	            <?php if( $medic_single_page_sidebar == 'right-sidebar' ) : ?>
					<div data-aos="fade-up" data-aos-duration="1600" class="col-lg-4">
			    		<div class="blog-details-right-area blog-right-sidebar">
							<?php dynamic_sidebar('page-sidebar'); ?>
						</div>
			    	</div>
		    	<?php endif; ?>

			</div>

		</div>

	</div><!-- .entry-content -->

</article><!-- #post-<?php the_ID(); ?> -->
