<?php
/**
 * Template part for displaying post details
 *
 * @package Medic
 */

global $medic; global $post;
$medic_single_post_sidebar = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_post', true); ?>

<!-- START PAGE TITLE AREA -->
<div class="page-title-area">
	<div class="container">
		<div class="page-title-content">
			<h2><?php single_post_title(); ?></h2>
			<ul>
				<li>
					<a href="<?php echo esc_url(home_url('/')); ?>">
						<?php echo esc_html('Home', 'medic'); ?>
					</a>
				</li>
				<li class="active"><?php single_post_title(); ?></li>
			</ul>
		</div>
	</div>
</div>
<!-- END PAGE TITLE AREA -->

<!-- START BLOG DETAILS AREA -->
<section class="blog-details-area ptb-70">
	<div class="container">
		<div class="row">
			<?php if( isset($medic['single-blog-layout']) && $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == 'default' || $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == '' || $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == 'left-sidebar' || $medic_single_post_sidebar == 'left-sidebar' ) : ?>
				<div data-aos="fade-up" data-aos-duration="800" class="col-lg-4">
					<div class="blog-details-right-area blog-left-sidebar">
						<?php dynamic_sidebar('blog-sidebar'); ?>
					</div>
				</div>
		    <?php endif; ?>

		    <?php if( $medic['single-blog-layout'] == '1' && $medic_single_post_sidebar == 'default' || $medic['single-blog-layout'] == '1' && $medic_single_post_sidebar == '' || $medic['single-blog-layout'] == '1' && $medic_single_post_sidebar == 'no-sidebar' || $medic_single_post_sidebar == 'no-sidebar' ) : ?>
                <div class="col-lg-12 full-width">
            <?php elseif( $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == 'default' || $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == '' || $medic['single-blog-layout'] == '2' && $medic_single_post_sidebar == 'left-sidebar' || $medic_single_post_sidebar == 'left-sidebar' ) : ?>
                <div class="col-lg-8">
            <?php elseif( $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == 'default' || $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == '' || $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == 'right-sidebar' || $medic_single_post_sidebar == 'right-sidebar' ) : ?>
                <div class="col-lg-8">        
            <?php endif; ?>
				<div class="blog-details-left-area">
					<div data-aos="fade-up" data-aos-duration="1200" class="blog-details-single-post">
						<div class="blog-details-img">
							<?php the_post_thumbnail(); ?> 
						</div>

						<?php if( get_post_type() == 'post' ) : ?>
						
						<ul>
							<li><i class="bx bx-time"></i>
								<?php 
								$archive_year  = get_the_time( 'Y' ); 
								$archive_month = get_the_time( 'm' ); 
								$archive_day   = get_the_time( 'd' ); 
								?>
								<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
								    <?php the_time('d M, Y'); ?>
								</a>
							</li>
							<li><i class="bx bx-user"></i>
								<a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author(); ?></a>
							</li>
							<li>
								<i class="bx bx-comment"></i> 
								<?php comments_popup_link('No comment','One comment','% comments','cmnt','comments off'); ?>
							</li>
						</ul>

						<?php endif; ?>

						<h3><?php the_title(); ?></h3>

						<?php the_content(); ?>

					</div>
                    
                    <?php if( isset($medic['show-share']) && get_post_type() == 'post' && $medic['show-share'] == 1 ) : ?>
						<div data-aos="fade-up" data-aos-duration="1600" class="blog-details-sheare">
							<div class="row align-items-center">
								<div class="col-lg-6 col-sm-6">
									<div class="blog-sheare-tag">
										<ul>
											<li><?php echo esc_html( $medic['share-text'] ); ?></li>
										</ul>
									</div>
								</div>

								<?php 
								$share_url   = get_the_permalink();
								$share_title = get_the_title();
								$share_desc  = get_the_excerpt(); ?>

								<div class="col-lg-6 col-sm-6">
									<ul class="social-icon">
										<li>
											<a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($share_url); ?>" onclick="window.open(this.href, 'facebook-share','width=580,height=296'); return false;" class="facebook" target="_blank"><i class='bx bxl-facebook'></i></a>
										</li>
										<li>
											<a href="https://twitter.com/share?text=<?php echo urlencode($share_title); ?>&url=<?php echo esc_url($share_url); ?>" target="_blank">
												<i class="bx bxl-twitter"></i>
											</a>
										</li>
										<li>
											<a href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url($share_url); ?>" target="_blank">
												<i class="bx bxl-pinterest-alt"></i>
											</a>
										</li>
										<li>
											<a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url($share_url); ?>&amp;title=<?php echo urlencode($share_title); ?>&amp;summary=&amp;source=<?php bloginfo('name'); ?>" onclick="window.open(this.href, 'linkedin','width=580,height=296'); return false;" class="linkedin" target="_blank"><i class="bx bxl-linkedin"></i></a>
										</li>
										<li>
											<?php if ( wp_is_mobile() != true ) : ?>
				                                <a href="https://api.whatsapp.com/send?phone=whatsappphonenumber&text=<?php echo esc_url($share_url); ?>" data-action="share/whatsapp/share" class="whatsapp" target="_blank"><i class='bx bxl-whatsapp'></i></a>
				                            <?php else : ?>
				                                <a href="whatsapp://send?text=<?php echo esc_url($share_url); ?>" class="whatsapp" target="_blank"><i class='bx bxl-whatsapp'></i></a>
				                            <?php endif; ?>
										</li>
									</ul>
								</div>
							</div>
						</div>
					<?php endif; ?>

					<?php
					if( isset($medic['show-navigation']) && $medic['show-navigation'] == 1 ) :
						$prevPost = get_previous_post(true);
						$nextPost = get_next_post(true); 
	                    if($prevPost || $nextPost) : ?>
							<div data-aos="fade-up" data-aos-duration="2000" class="prev-next">
								<div class="row align-items-center">
									<?php if($prevPost) :
										$args = array(
							                'posts_per_page' => 1,
							                'include' => $prevPost->ID
							            ); 
							            $prevPost = get_posts($args); 
							            foreach ($prevPost as $post) {
										    setup_postdata($post); ?>
											<div class="col-lg-6 col-sm-6">
												<div class="prev-post">
													<a href="<?php the_permalink(); ?>">
														<i class="flaticon-left"></i>
														<?php echo esc_html('Previous post', 'medic'); ?>
													</a>
												</div>
											</div>
											<?php wp_reset_postdata();
										} 
	                                endif; ?>
	                                <?php if($nextPost) :
	                                    $args = array(
							                'posts_per_page' => 1,
							                'include' => $nextPost->ID
							            ); 
							            $nextPost = get_posts($args); 
							            foreach ($nextPost as $post) {
										    setup_postdata($post); ?>
											<div class="col-lg-6 col-sm-6">
												<div class="next-post">
													<a href="<?php the_permalink(); ?>">
														<?php echo esc_html('Next post', 'medic'); ?>
														<i class="flaticon-right"></i>
													</a>
												</div>
											</div>
											<?php wp_reset_postdata();
										}
									endif; ?>
								</div>
							</div>
					    <?php endif; ?>
				    <?php endif; ?>
                    
                    <?php if( get_post_type() == 'post' ) : ?>
						<div data-aos="fade-up" data-aos-duration="2400" class="profile">
							<div class="profile-img">
								<?php echo get_avatar( get_the_author_meta( 'ID' )); ?>
	                            <h3><?php the_author(); ?></h3>
								<p><?php the_author_meta('description'); ?></p>
							</div>
						</div>
					<?php endif; ?>

                    <?php if( isset($medic['show-comment']) && $medic['show-comment'] == 1 ) : ?>
						<div data-aos="fade-up" data-aos-duration="2800" class="contact-area">
							<div class="row">
								<div class="col-lg-12">
									<div class="contact-form">
									    <?php 
										if ( comments_open() || get_comments_number() ) :
											comments_template();
										endif; ?>
									</div>
								</div>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			
            <?php if( isset($medic['single-blog-layout']) && $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == 'default' || $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == '' || $medic['single-blog-layout'] == '3' && $medic_single_post_sidebar == 'right-sidebar' || $medic_single_post_sidebar == 'right-sidebar' ) : ?>
				<div data-aos="fade-up" data-aos-duration="1600" class="col-lg-4">
					<div class="blog-details-right-area blog-right-sidebar">
						<?php dynamic_sidebar('blog-sidebar'); ?>
					</div>
				</div>
		    <?php endif; ?>
		</div>
	</div>
</section>
<!-- END BLOG DETAILS AREA -->
