<?php
/**
 * Template part for displaying posts
 *
 * @package Medic
 */

global $medic; ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<!-- START PAGE TITLE AREA -->
	<div class="page-title-area">
		<div class="container">
			<div class="page-title-content">
				<h2><?php the_archive_title(); ?></h2>
				<ul>
					<li>
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<?php echo esc_html('Home', 'medic'); ?>
						</a>
					</li>
					<li class="active"><?php the_archive_title(); ?></li>
				</ul>
			</div>
		</div>
	</div>
	<!-- END PAGE TITLE AREA -->

	<!-- START BLOG AREA -->
	<section class="blog-area bg-color ptb-70">
		<div class="container">
			<div class="row justify-content-center">
                <?php if( isset($medic['blog-page-layout']) && $medic['blog-page-layout'] == '1' ) : ?> 
	                <?php while( have_posts() ) : the_post(); ?>
						<div data-aos="fade-up" data-aos-duration="1200" class="col-lg-4 col-md-6">
							<div class="single-blog">
								<?php medic_post_thumbnail(); ?>
								<div class="blog-content">
									<ul>
										<li>
											<a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author(); ?></a>
										</li>
										<li>
											<?php 
											$archive_year  = get_the_time( 'Y' ); 
											$archive_month = get_the_time( 'm' ); 
											$archive_day   = get_the_time( 'd' ); 
											?>
											<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
											    <?php the_time('d M, Y'); ?>
											</a>
										</li>
									</ul>
									<a href="<?php the_permalink(); ?>">
										<h3><?php the_title(); ?></h3>
									</a>
									<p><?php echo esc_html(wp_trim_words( get_the_excerpt(), '16', '' )); ?></p>
									<a href="<?php the_permalink(); ?>" class="read-more">
										<?php echo esc_html( $medic['read-more'] ); ?>
									</a>
								</div>
							</div>
						</div>
					<?php endwhile; ?>
					<?php wp_reset_query();
					if( isset($medic['show-pagination']) && $medic['show-pagination'] == 1 ) :
						$prev_link = get_previous_posts_link(__('&laquo; Older Entries', 'medic'));
		                $next_link = get_next_posts_link(__('Newer Entries &raquo;', 'medic'));
						if( $prev_link || $next_link ) : ?>  
							<div data-aos="fade-up" data-aos-duration="1200" class="col-lg-12 col-md-12">
			                    <div class="pagination-area text-center">
			                    	<?php 
				                        the_posts_pagination(array(
				                        'show_all'           => 'false',
				                        'prev_text'          => sprintf('<i class="bx bx-chevrons-left"></i>'),
				                        'next_text'          => sprintf('<i class="bx bx-chevrons-right"></i>'),
				                        'screen_reader_text' => ' ',
				                        )); 
				                    ?>
			                    </div>
			                </div>
		                <?php endif; ?>
	                <?php endif; ?>
	            <?php endif; ?>
	            <?php if( isset($medic['blog-page-layout']) && $medic['blog-page-layout'] == '2' ) : ?>
	                <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-4 col-md-12">
	                    <div class="blog-details-right-area blog-left-sidebar">
	                        <?php dynamic_sidebar('blog-sidebar'); ?>
	                    </div>
	                </div> 
	            <?php endif; ?>
	            <?php if( isset($medic['blog-page-layout']) && $medic['blog-page-layout'] == '2' || isset($medic['blog-page-layout']) && $medic['blog-page-layout'] == '3' ) : ?>
	                <div class="col-lg-8 col-md-12">
	                    <div class="row"> 
	                        <?php while( have_posts() ) : the_post(); ?>
	                        <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-6 col-md-6">
								<div class="single-blog">
									<?php medic_post_thumbnail(); ?>
									<div class="blog-content">
										<ul>
											<li>
												<a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author(); ?></a>
											</li>
											<li>
												<?php the_time('d M, Y'); ?>
											</li>
										</ul>
										<a href="<?php the_permalink(); ?>">
											<h3><?php the_title(); ?></h3>
										</a>
										<p><?php echo esc_html(wp_trim_words( get_the_excerpt(), '16', '' )); ?></p>
										<a href="<?php the_permalink(); ?>" class="read-more">
											<?php echo esc_html( $medic['read-more'] ); ?>
										</a>
									</div>
								</div>
							</div>
						    <?php endwhile; ?>
						    <?php wp_reset_query(); ?>
						</div>
						<?php
						if( isset($medic['show-pagination']) && $medic['show-pagination'] == 1 ) : 
							$prev_link = get_previous_posts_link(__('&laquo; Older Entries', 'medic'));
			                $next_link = get_next_posts_link(__('Newer Entries &raquo;', 'medic'));
							if( $prev_link || $next_link ) : ?>  
								<div data-aos="fade-up" data-aos-duration="1200" class="col-lg-12 col-md-12">
				                    <div class="pagination-area text-center">
				                    	<?php 
					                        the_posts_pagination(array(
					                        'show_all'           => 'false',
					                        'prev_text'          => sprintf('<i class="bx bx-chevrons-left"></i>'),
					                        'next_text'          => sprintf('<i class="bx bx-chevrons-right"></i>'),
					                        'screen_reader_text' => ' ',
					                        )); 
					                    ?>
				                    </div>
				                </div>
			                <?php endif; ?>
		                <?php endif; ?>
	                </div>
	            <?php endif; ?>
	            <?php if( isset($medic['blog-page-layout']) && $medic['blog-page-layout'] == '3' ) : ?>
	                <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-4 col-md-12">
	                    <div class="blog-details-right-area blog-right-sidebar">
	                        <?php dynamic_sidebar('blog-sidebar'); ?>
	                    </div>
	                </div>
	            <?php endif; ?>
			</div>
		</div>
	</section>
	<!-- END BLOG AREA -->

</article><!-- #post-<?php the_ID(); ?> -->
