<?php

/**
 * Elementor About Widget.
 *
 * @since 1.1
 */

class Medic_About_Widget extends \Elementor\Widget_Base {

	public function get_name() {
        return 'about-us';
    }

	public function get_title() {
        return __( 'About Us', 'medic-extension' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'medic-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'about_area',
            [
                'label' => esc_html__( 'About Area', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_about_area',
            [
                'label' => __( 'Show About Area?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'about_style',
            [
                'label' => __( 'About Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style-one' => __( 'Style One', 'medic-extension' ),
                    'style-two' => __( 'Style Two', 'medic-extension' )
                ],
                'default' => 'style-one'
            ]
        );

        $this->add_control(
            'about_top_title',
            [
                'label' => __( 'About Top Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Top Title', 'medic-extension' ),
                'default'  => __( 'About Us', 'medic-extension' )
            ]
        );

        $this->add_control(
            'about_title',
            [
                'label' => __( 'About Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Tackle The Challenge Of Delivering Health Care', 'medic-extension' )
            ]
        );

        $this->add_control(
            'about_desc',
            [
                'label' => __( 'About Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi consectetur adipiscing elit incididunt labore dolore magna.', 'medic-extension')
            ]
        );
        
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'single_feature',
            [
                'label' => __( 'Single Feature', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Feature', 'medic-extension' ),
                'default' => __( 'Consultations Wif Specialized Pediatricians', 'medic-extension')
            ]
        );

        $this->add_control(
            'features',
            [
                'label' => __( 'Features', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Feature #1', 'medic-extension' ),
                        'list_content' => __( 'Feature Content', 'medic-extension' )
                    ]
                ],
                'condition' => [
                    'about_style' => 'style-one'
                ]
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button Text', 'medic-extension' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __('More About Us', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type',
            [
                'label'         => esc_html__( 'Button Link Type', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options' => [
                    '1'     => esc_html__( 'Link To Page', 'medic-extension' ),
                    '2'     => esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page',
            [
                'label'         => esc_html__( 'Button Link Page', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options'       => medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link',
            [
                'label'     => esc_html__('Button External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'about_img',
            [
                'label' => __( 'About Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $this->add_control(
            'video_img',
            [
                'label' => __( 'Video Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true,
                'condition' => [
                    'about_style' => 'style-two'
                ]
            ]
        );

        $this->add_control(
            'about_video_title',
            [
                'label' => __( 'About Video Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Video Title', 'medic-extension' ),
                'default'  => __( 'See How We Provide Services to Our Clients', 'medic-extension' ),
                'condition' => [
                    'about_style' => 'style-two'
                ]
            ]
        );

        $this->add_control(
            'about_video_link',
            [
                'label' => __( 'About Video Link', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Video Link', 'medic-extension' ),
                'default'  => __( 'https://www.youtube.com/watch?v=TdK0jRFpWPQ' )
            ]
        );

        $this->add_control(
            'about_bg_color',
            [
                'label' => __( 'About Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '.about-area, .about-area-two' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'counter_area',
            [
                'label' => esc_html__( 'Counter Area', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_counter_area',
            [
                'label' => __( 'Show Counter Area?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __( 'Icon Type', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'input_type' => 'SELECT',
                'options' => [
                    'general' => __( 'General', 'medic-extension' ),
                    'library' => __( 'Library', 'medic-extension' ),
                ],
                'default' => 'general'
            ]
        );

        $repeater->add_control(
            'single_counter_icon1', [
                'label' => __( 'Counter Icon', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::ICON,
                'show_label' => true,
                'options' => medic_extension_icons(),
                'default' => 'bx bx-user-circle',
                'condition' => [
                    'icon_type' => 'general'
                ]
            ]
        );

        $repeater->add_control(
            'single_counter_icon2', [
                'label' => __( 'Counter Icon', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'show_label' => true,
                'condition' => [
                    'icon_type' => 'library'
                ]
            ]
        );

        $repeater->add_control(
            'single_counter_data',
            [
                'label' => __( 'Counter Data', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'placeholder' => __( 'Data', 'medic-extension' ),
                'default' => __( '540')
            ]
        );

        $repeater->add_control(
            'single_counter_title',
            [
                'label' => __( 'Counter Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default' => __( 'Expert Doctors', 'medic-extension')
            ]
        );

        $this->add_control(
            'counter',
            [
                'label' => __( 'Counter', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Counter #1', 'medic-extension' ),
                        'list_content' => __( 'Counter Content', 'medic-extension' )
                    ]
                ]
            ]
        );

        $this->add_control(
            'counter_bg_color',
            [
                'label' => __( 'Counter Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-area' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'why_choose_area',
            [
                'label' => esc_html__( 'Why Choose Area', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_why_choose_area',
            [
                'label' => __( 'Show Why Choose Area?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'why_choose_top_title',
            [
                'label' => __( 'Why Choose Top Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Top Title', 'medic-extension' ),
                'default'  => __( 'Why Choose Us', 'medic-extension' )
            ]
        );

        $this->add_control(
            'why_choose_title',
            [
                'label' => __( 'Why Choose Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Why We Are Different', 'medic-extension' )
            ]
        );

        $this->add_control(
            'why_choose_desc',
            [
                'label' => __( 'Why Choose Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'why_choose_tab_title',
            [
                'label' => __( 'Tab Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Tab Title', 'medic-extension' ),
                'default'  => __( 'Certified Doctor', 'medic-extension' )
            ]
        );

        $this->add_control(
            'tab_title',
            [
                'label' => __( 'Why Choose Tab Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Tab Title #1', 'medic-extension' ),
                        'list_content' => __( 'Tab Title', 'medic-extension' )
                    ]
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'why_choose_img',
            [
                'label' => __( 'Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $repeater->add_control(
            'why_choose_video_link',
            [
                'label' => __( 'Video Link', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Video Link', 'medic-extension' ),
                'default'  => __( 'https://www.youtube.com/watch?v=TdK0jRFpWPQ' )
            ]
        );

        $repeater->add_control(
            'why_choose_content',
            [
                'label' => __( 'Content', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'placeholder' => __( 'Content', 'medic-extension' ),
                'default'  => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi consectetur adipiscing elit incididunt labore dolore magna. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi consectetur adipiscing elit incididunt labore dolore magna.', 'medic-extension' )
            ]
        );

        $this->add_control(
            'tab_content',
            [
                'label' => __( 'Why Choose Tab Content', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => __( 'Tab Content #1', 'medic-extension' ),
                        'list_content' => __( 'Tab Content', 'medic-extension' )
                    ]
                ]
            ]
        );

        $this->add_control(
            'why_choose_bg_color',
            [
                'label' => __( 'Why Choose Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .why-choose-area' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display(); ?>

        <!-- About Button Link -->
        <?php if($settings['btn_link_type'] == '2') : 
            $target = $settings['btn_ex_link']['is_external'] ? ' target="_blank"' : '';
            $nofollow = $settings['btn_ex_link']['nofollow'] ? ' rel="nofollow"' : ''; 
        elseif($settings['btn_link_type'] == '1') : 
            $target = '';
            $nofollow = '';
        endif;

        // Get Button Link
        if($settings['show_btn'] == 'yes') {
            if($settings['btn_link_type'] == 1) {
                $btn_link = get_page_link( $settings['btn_link_to_page'] );
            } else {
                $btn_link = $settings['btn_ex_link']['url'];
            }
        } ?>
        
        <?php if( $settings['show_about_area'] == 'yes' ): ?>

            <?php if( $settings['about_style'] == 'style-one' ): ?>
                <!-- START ABOUT AREA -->
                <section class="about-area ptb-70">
                    <div class="container">
                        <div class="row">
                            <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-6">
                                <div class="about-content mb-0">
                                    <span class="top-title"><?php echo esc_html($settings['about_top_title']); ?></span>
                                    <h2><?php echo esc_html($settings['about_title']); ?></h2>
                                    <p><?php echo wp_kses_post($settings['about_desc']); ?></p>
                                    
                                    <ul>
                                        <?php foreach (  $settings['features'] as $item ) { ?>
                                            <li>
                                                <i class="bx bx-check"></i>
                                                <?php echo wp_kses_post($item['single_feature']); ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                   
                                    <!-- Button Part Start --> 
                                    <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' ): ?>
                                        <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php endif; ?>
                                    <!-- Button Part End -->

                                </div>
                            </div>

                            <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-6">
                                <div class="about-img" style="background-image: url(<?php echo esc_url( $settings['about_img']['url'] ); ?>)">
                                    <?php if($settings['about_video_link'] != '') : ?>
                                        <div class="video-wrap">
                                            <a href="<?php echo esc_html($settings['about_video_link']); ?>" class="popup-youtube video-btn">
                                                <i class="bx bx-play"></i>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- END ABOUT AREA -->
            <?php elseif( $settings['about_style'] == 'style-two' ): ?>
                <!-- START ABOUT US AREA -->
                <section class="about-area-two ptb-70">
                    <div class="container">
                        <div class="row align-items-center">
                            <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-6">
                                <div class="about-img-two">
                                    <?php if($settings['about_img']['url'] != '') : ?>
                                        <img src="<?php echo esc_url( $settings['about_img']['url'] ); ?>" alt="Image">
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-6">
                                <div class="about-content-two">
                                    <span class="top-title"><?php echo esc_html($settings['about_top_title']); ?></span>
                                    <h2><?php echo esc_html($settings['about_title']); ?></h2>
                                    <p><?php echo wp_kses_post($settings['about_desc']); ?></p>

                                    <!-- Button Part Start --> 
                                    <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' ): ?>
                                        <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php endif; ?>
                                    <!-- Button Part End -->

                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- END ABOUT US AREA -->

                <!-- START ABOUT VIDEO AREA -->
                <section data-aos="fade-up" data-aos-duration="1200" class="about-video-area ptb-100" style="background-image: url(<?php echo esc_url( $settings['video_img']['url'] ); ?>)">
                    <div class="container">
                        <div class="video-section-title">
                            <h2><?php echo esc_html($settings['about_video_title']); ?></h2>
                        </div>

                        <div class="row">
                            <div class="about-video-button">
                                <?php if($settings['about_video_link'] != '') : ?>
                                    <a href="<?php echo esc_html($settings['about_video_link']); ?>" class="popup-youtube video-btn">
                                        <i class='bx bx-play'></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- END ABOUT VIDEO AREA -->

            <?php endif; ?>

        <?php endif; ?>
        
        <?php if( $settings['show_counter_area'] == 'yes' ): ?> 
            <!-- START COUNTER AREA -->
            <section class="counter-area ptb-70">
                <div class="container">
                    <div class="row">
                        <?php foreach ( $settings['counter'] as $item ) : ?>
                            <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-3 col-sm-6">
                                <div class="single-counter">
                                    <?php if( $item['icon_type'] == 'general' ) : ?>
                                        <i class="<?php echo wp_kses_post( $item['single_counter_icon1'] ); ?>"></i>
                                    <?php else: 
                                        medic_render_icon( $item, 'icon', 'single_counter_icon2' );
                                    endif; ?>
                                    <h2>
                                        <span class="odometer" data-count="<?php echo esc_html($item['single_counter_data']); ?>">00</span> 
                                        <span class="target">+</span>
                                    </h2>
                                    <p><?php echo esc_html($item['single_counter_title']); ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>
            <!-- END COUNTER AREA -->
        <?php endif; ?>

        <?php if( $settings['show_why_choose_area'] == 'yes' ): ?>
            <!-- START WHY CHOOSE AREA -->
            <section class="why-choose-area ptb-70">
                <div class="container">
                    <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                        <span class="top-title"><?php echo esc_html($settings['why_choose_top_title']); ?></span>
                        <h2><?php echo esc_html($settings['why_choose_title']); ?></h2>
                        <p><?php echo wp_kses_post($settings['why_choose_desc']); ?></p>
                    </div>

                    <div class="tab choose-tab">
                        <ul data-aos="fade-up" data-aos-duration="1600" class="tabs">
                            <?php foreach ( $settings['tab_title'] as $item ) : ?>
                                <li>
                                    <?php echo esc_html($item['why_choose_tab_title']); ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        
                        <div class="why-choose-wrap">
                            <div class="tab_content">
                                <?php foreach ( $settings['tab_content'] as $item ) : ?>
                                <div data-aos="fade-up" data-aos-duration="2000" class="tabs_item">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="why-choose-img" style="background-image: url(<?php echo esc_url( $item['why_choose_img']['url'] ); ?>)">
                                                <?php if($item['why_choose_video_link'] != '') : ?>
                                                    <div class="video-wrap">
                                                        <a href="<?php echo esc_html($item['why_choose_video_link']); ?>" class="popup-youtube video-btn">
                                                            <i class="bx bx-play"></i>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="about-content why-choose-content">
                                                <p><?php echo wp_kses_post($item['why_choose_content']); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- END WHY CHOOSE AREA -->
        <?php endif; ?>

        <?php

	}

}
