<?php

/**
 * Elementor Appointment Widget.
 *
 * @since 1.1
 */

class Medic_Appointment_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'appointment';
	}

	public function get_title() {
		return __( 'Appointment', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-favorite';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'appointment_section',
			[
				'label' => __( 'Appointment Section', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

	    $this->add_control(
			'appointment_subtitle',
			[
				'label' => __( 'Appointment Subtitle', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Subtitle', 'medic-extension' ),
				'default'  => __( 'Make An Appointment', 'medic-extension' )
			]
		);

		$this->add_control(
			'appointment_title',
			[
				'label' => __( 'Appointment Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( 'We Are Here For You', 'medic-extension' )
			]
		);

		$this->add_control(
            'appointment_bg_color',
            [
                'label' => __( 'Appointment Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '.appointment-area' => 'background-color: {{VALUE}}'
                ]
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'appointment_form',
			[
				'label' => __( 'Appointment Form', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'appointment_form_type',
			[
				'label' => __( 'Form Type', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'input_type' => 'SELECT',
				'options' => [
					'dropdown' => __( 'Dropdown', 'medic-extension' ),
					'shortcode' => __( 'Shortcode', 'medic-extension' ),
				],
				'default' => 'dropdown'
			]
		);

		$this->add_control(
            'select_appointment_form',
            [
                'label' => esc_html__('Select Form', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => medic_get_wpcf7_list(),
                'default' => '0',
                'condition' => [
                    'appointment_form_type' => 'dropdown'
                ]
            ]
        );

		$this->add_control(
			'appointment_form_shortcode',
			[
				'label' => __( 'Form Shortcode', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'input_type' => 'text',
				'placeholder' => __( 'Shortcode', 'medic-extension' ),
				'condition' => [
                    'appointment_form_type' => 'shortcode'
                ]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'appointment_img',
			[
				'label' => __( 'Appointment Image', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
            'featured_img',
            [
                'label' => __( 'Featured Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $this->add_control(
            'featured_img_height',
            [
                'label' => __( 'Featured Image Height', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 800
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-area .appointment-img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control(
            'featured_img_width',
            [
                'label' => __( 'Featured Image Width', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 500
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-area .appointment-img' => 'width: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

		<!-- START APPOINTMENT AREA -->
		<section class="appointment-area ptb-70">
			<div class="container">
				<div class="row">
					<div data-aos="fade-up" data-aos-duration="1200" class="col-lg-6">
						<div class="appointment-here-form">
							<span class="top-title"><?php echo esc_html($settings['appointment_subtitle']); ?></span>
							<h2><?php echo esc_html($settings['appointment_title']); ?></h2>

							<?php if($settings['appointment_form_type'] == 'dropdown' && !empty($settings['select_appointment_form'])) :
		                            echo do_shortcode('[contact-form-7 id="' . $settings['select_appointment_form'] . '" ]');
		                    else:
		                        echo do_shortcode($settings['appointment_form_shortcode']);
		                    endif; ?>
						</div>
					</div>
					<div data-aos="fade-up" data-aos-duration="1600" class="col-lg-6">
						<?php if($settings['featured_img']['url'] != '') : ?>
						    <div class="appointment-img" style="background-image:url(<?php echo esc_url($settings['featured_img']['url']); ?>);"></div>
					<?php endif; ?>
					</div>
				</div>
			</div>
		</section>
		<!-- END APPOINTMENT AREA -->

		<?php

    }

}
