<?php

/**
 * Elementor Banner Widget.
 *
 * @since 1.1
 */

class Medic_Banner_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'banner';
	}

	public function get_title() {
		return __( 'Banner', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-banner';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
            'banner_content',
            [
                'label' => esc_html__( 'Banner Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'banner_subtitle',
            [
                'label' => __( 'Banner Subtitle', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Subtitle', 'medic-extension' ),
                'default'  => __( 'Welcome To Medic', 'medic-extension' )
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => __( 'Banner Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Exceptional Medical Specialty Healthcare', 'medic-extension' )
            ]
        );

        $this->add_control(
            'banner_desc',
            [
                'label' => __( 'Banner Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt dolore magna aliqua. Quis ipsum suspendisse ultrices gravida.', 'medic-extension')
            ]
        );

        $this->add_control(
            'banner_bg_img',
            [
                'label' => __( 'Banner Background Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $this->add_control(
            'banner_img',
            [
                'label' => __( 'Banner Image', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
                'show_label' => true
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'full',
                'separator' => 'none',
                'exclude' => [
                    'full',
                    'custom',
                    'large',
                    'shop_catalog',
                    'shop_single',
                    'shop_thumbnail'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_content',
            [
                'label' => esc_html__( 'Button Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'button_text1',
            [
                'label'     => esc_html__( 'Button One Text', 'medic-extension' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __('View Departments', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type1',
            [
                'label'         => esc_html__( 'Button One Link Type', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options' => [
                    '1'     => esc_html__( 'Link To Page', 'medic-extension' ),
                    '2'     => esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page1',
            [
                'label'         => esc_html__( 'Button One Link Page', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options'       => medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type1' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link1',
            [
                'label'     => esc_html__('Button One External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type1' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'button_text2',
            [
                'label'     => esc_html__( 'Button Two Text', 'medic-extension' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __('Contact Us', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type2',
            [
                'label'         => esc_html__( 'Button Two Link Type', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options' => [
                    '1'     => esc_html__( 'Link To Page', 'medic-extension' ),
                    '2'     => esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page2',
            [
                'label'         => esc_html__( 'Button Two Link Page', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options'       => medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type2' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link2',
            [
                'label'     => esc_html__('Button Two External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type2' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <!-- Banner Button Link -->
        <?php if($settings['btn_link_type1'] == '2') : 
            $target1 = $settings['btn_ex_link1']['is_external'] ? ' target="_blank"' : '';
            $nofollow1 = $settings['btn_ex_link1']['nofollow'] ? ' rel="nofollow"' : ''; 
        elseif($settings['btn_link_type1'] == '1') : 
            $target1 = '';
            $nofollow1 = '';
        endif; 

        if($settings['btn_link_type2'] == '2') : 
            $target2 = $settings['btn_ex_link2']['is_external'] ? ' target="_blank"' : '';
            $nofollow2 = $settings['btn_ex_link2']['nofollow'] ? ' rel="nofollow"' : ''; 
        elseif($settings['btn_link_type2'] == '1') : 
            $target2 = '';
            $nofollow2 = '';
        endif; 

        // Get Button Link
        if($settings['btn_link_type1'] == '1') {
            $btn_link1 = get_page_link( $settings['btn_link_to_page1'] );
        } else {
            $btn_link1 = $settings['btn_ex_link1']['url'];
        }

        if($settings['btn_link_type2'] == '1') {
            $btn_link2 = get_page_link( $settings['btn_link_to_page2'] );
        } else {
            $btn_link2 = $settings['btn_ex_link2']['url'];
        }

        ?>
        
        <!-- START BANNER AREA -->
		<section class="banner-area" style="background-image: url(<?php echo esc_url( $settings['banner_bg_img']['url'] ); ?>)">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="banner-content">
                                    <span class="wow fadeInUp" data-wow-delay=".4s">
                                        <?php echo esc_html($settings['banner_subtitle']); ?>
                                    </span>
                                    <h1 class="wow fadeInUp" data-wow-delay=".6s">
                                        <?php echo esc_html($settings['banner_title']); ?>
                                    </h1>
                                    <p class="wow fadeInUp" data-wow-delay=".8s">
                                        <?php echo wp_kses_post($settings['banner_desc']); ?>
                                    </p>
                                    
                                    <?php if( $settings['show_btn'] == 'yes' ): ?>
                                        <div class="banner-btn wow fadeInUp" data-wow-delay=".9s">
                                            <?php if( $settings['button_text1'] != '' ): ?>
                                                <a href="<?php echo esc_url($btn_link1); ?>" <?php echo wp_kses_post( $target1 ); ?> <?php echo wp_kses_post( $nofollow1 ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text1'] ); ?></a>
                                            <?php endif; ?>
                                            <?php if( $settings['button_text2'] != '' ): ?>
                                                <a href="<?php echo esc_url($btn_link2); ?>" <?php echo wp_kses_post( $target2 ); ?> <?php echo wp_kses_post( $nofollow2 ); ?> class="medic-default-btn active"><?php echo esc_html( $settings['button_text2'] ); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="banner-img wow fadeInUp" data-wow-delay=".9s">
                                    <?php if( ! $settings['banner_img']['url'] == '' ) : ?>
                                        <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'banner_img' ); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- END BANNER AREA -->

        <?php

    }

}
