<?php

/**
 * Elementor Doctor Widget.
 *
 * @since 1.1
 */

class Medic_Doctor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'doctor';
	}

	public function get_title() {
		return __( 'Doctor', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'doctor_section',
			[
				'label' => __( 'Doctor Section', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'section_subtitle',
			[
				'label' => __( 'Section Subtitle', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Subtitle', 'medic-extension' ),
				'default'  => __( "Our Doctor's", 'medic-extension' )
			]
		);

	    $this->add_control(
			'section_title',
			[
				'label' => __( 'Section Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( "Our Expert Doctor's", 'medic-extension' )
			]
		);

		$this->add_control(
			'section_desc',
			[
				'label' => __( 'Section Description', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Description', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'doctor_content',
			[
				'label' => __( 'Doctor Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
            'doctor_item_style',
            [
                'label' => __( 'Select Doctor Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'grid' => __( 'Grid', 'medic-extension' ),
                    'slider' => __( 'Slider', 'medic-extension' )
                ],
                'default' => 'grid'
            ]
        );

		$this->add_control(
			'doctor_item_column',
			[
				'label' => __( 'Doctor Item Column', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'columns-2' => __( '2', 'medic-extension' ),
					'columns-3' => __( '3', 'medic-extension' ),
					'columns-4' => __( '4', 'medic-extension' )
				],
				'default' => 'columns-3',
				'condition' => [
                    'doctor_item_style' => 'grid'
                ]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'single_doctor_img', [
				'label' => __( 'Image', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src()
                ],
				'show_label' => true
			]
		);

		$repeater->add_control(
			'single_doctor_name', [
				'label' => __( 'Name', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => __( 'Title', 'medic-extension' ),
				'default'  => __( 'Dr. Anthony', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'single_doctor_position', [
				'label' => __( 'Designation', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Designation', 'medic-extension' ),
				'default'  => __( 'Surgeon, Сardiologist', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'show_social',
			[
				'label' => __( 'Want to Show Social?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
			]
		);

		$repeater->add_control(
			'single_social_icon_one', 
			[
				'label' => __( 'Social Icon 1', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'show_label' => true,
				'options' => medic_extension_icons(),
				'default' => 'bx bxl-facebook',
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_link1',
			[
				'label' => __( 'Social Link 1', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_icon_two', 
			[
				'label' => __( 'Social Icon 2', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'show_label' => true,
				'options' => medic_extension_icons(),
				'default' => 'bx bxl-twitter',
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_link2',
			[
				'label' => __( 'Social Link 2', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_icon_three', 
			[
				'label' => __( 'Social Icon 3', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'show_label' => true,
				'options' => medic_extension_icons(),
				'default' => 'bx bxl-instagram',
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_link3',
			[
				'label' => __( 'Social Link 3', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_icon_four', 
			[
				'label' => __( 'Social Icon 4', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'show_label' => true,
				'options' => medic_extension_icons(),
				'default' => 'bx bxl-linkedin',
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$repeater->add_control(
			'single_social_link4',
			[
				'label' => __( 'Social Link 4', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::URL,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false
				],
				'condition' => [
                    'show_social' => 'yes'
                ]
			]
		);

		$this->add_control(
			'single_doctor',
			[
				'label' => __( 'Single Doctor', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Single Doctor #1', 'medic-extension' ),
						'list_content' => __( 'Single Doctor Content', 'medic-extension' )
					]
				]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); ?>

        <!-- Doctor Column Style -->
        <?php if($settings['doctor_item_style'] == 'grid') :
		    if( $settings['doctor_item_column'] == 'columns-2' ) :
				$doctor_column = 'col-lg-6 col-md-6 col-sm-12';
			elseif( $settings['doctor_item_column'] == 'columns-3' ) :
				$doctor_column = 'col-lg-4 col-md-6 col-sm-12';
			elseif( $settings['doctor_item_column'] == 'columns-4' ) :
				$doctor_column = 'col-lg-3 col-md-6 col-sm-12';
			endif;
	    endif; ?>

        <!-- START DOCTORS AREA -->
    	<section class="doctor-area ptb-70">
            <div class="container"> 
                <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                	<span class="top-title"><?php echo esc_html($settings['section_subtitle']); ?></span>
                    <h2><?php echo esc_html($settings['section_title']); ?></h2>
                    <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                </div>
                <?php if($settings['doctor_item_style'] == 'grid') : ?>
                    <div class="row justify-content-center">
                <?php elseif($settings['doctor_item_style'] == 'slider') : ?>
                    <div class="doctor-wrap owl-carousel owl-theme">
                <?php endif; ?>
                	<?php foreach ( $settings['single_doctor'] as $item ) : ?>
	                	<?php if($settings['doctor_item_style'] == 'grid') : ?>
	                        <div data-aos="fade-up" data-aos-duration="1600" class="<?php echo esc_attr( $doctor_column ); ?>">
	                    <?php elseif($settings['doctor_item_style'] == 'slider') : ?>
	                        <div class="doctor-slider">
	                    <?php endif; ?>
	                		<div class="single-doctor">
	                            <?php if( ! $item['single_doctor_img']['url'] == '' ) : ?>
		                            <img src="<?php echo esc_url( $item['single_doctor_img']['url'] ); ?>" alt="image">
	                            <?php endif; ?>
	                            <div class="doctor-content">
	                                <h3>
	                                	<?php echo esc_html($item['single_doctor_name']); ?>
	                                </h3>
	                                <span class="designation">
	                                	<?php echo esc_html($item['single_doctor_position']); ?>
	                                </span>
	                            </div>
                                <?php if( $item['show_social'] == 'yes' ) : ?>
	                                <ul class="social">
	                                    <li>
	                                    	<?php $target1 = $item['single_social_link1']['is_external'] ? ' target="_blank"' : '';
                                            $nofollow1 = $item['single_social_link1']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	                                    	<a href="<?php echo esc_url($item['single_social_link1']['url']); ?>" <?php echo wp_kses_post( $target1 ); ?> <?php echo wp_kses_post( $nofollow1 ); ?>>
	                                    		<?php if( $item['single_social_icon_one'] != '') : ?>
	                                    		    <i class="<?php echo wp_kses_post( $item['single_social_icon_one'] ); ?>"></i>
	                                    	    <?php endif; ?>
	                                    	</a>
	                                    </li>
	                                    <li>
	                                    	<?php $target2 = $item['single_social_link2']['is_external'] ? ' target="_blank"' : '';
                                            $nofollow2 = $item['single_social_link2']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	                                    	<a href="<?php echo esc_url($item['single_social_link2']['url']); ?>" <?php echo wp_kses_post( $target2 ); ?> <?php echo wp_kses_post( $nofollow2 ); ?>>
			                                	<?php if( $item['single_social_icon_two'] != '') : ?>
	                                    		    <i class="<?php echo wp_kses_post( $item['single_social_icon_two'] ); ?>"></i>
	                                    	    <?php endif; ?>
	                                    	</a>
	                                    </li>
	                                    <li>
	                                    	<?php $target3 = $item['single_social_link3']['is_external'] ? ' target="_blank"' : '';
                                            $nofollow3 = $item['single_social_link3']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	                                    	<a href="<?php echo esc_url($item['single_social_link3']['url']); ?>" <?php echo wp_kses_post( $target3 ); ?> <?php echo wp_kses_post( $nofollow3 ); ?>>
			                                	<?php if( $item['single_social_icon_three'] != '') : ?>
	                                    		    <i class="<?php echo wp_kses_post( $item['single_social_icon_three'] ); ?>"></i>
	                                    	    <?php endif; ?>
	                                    	</a>
	                                    </li>
	                                    <li>
	                                    	<?php $target4 = $item['single_social_link4']['is_external'] ? ' target="_blank"' : '';
                                            $nofollow4 = $item['single_social_link4']['nofollow'] ? ' rel="nofollow"' : ''; ?>
	                                    	<a href="<?php echo esc_url($item['single_social_link4']['url']); ?>" <?php echo wp_kses_post( $target4 ); ?> <?php echo wp_kses_post( $nofollow4 ); ?>>
			                                	<?php if( $item['single_social_icon_four'] != '') : ?>
	                                    		    <i class="<?php echo wp_kses_post( $item['single_social_icon_four'] ); ?>"></i>
	                                    	    <?php endif; ?>
	                                    	</a>
	                                    </li>
	                                </ul>
                                <?php endif; ?>
	                        </div>
	                	</div>			       
                    <?php endforeach; ?>			               
                </div>
            </div>
        </section>
	    <!-- END DOCTORS AREA -->

    <?php

	}

}
