<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Medic
 */

get_header();

global $medic; ?>

	<main id="primary" class="site-main">

		<!-- Start 404 Error Page -->
		<div class="error-area ptb-70">
			<div class="error-content-wrap">
				<?php if(isset($medic['404-page-image']['url']) && $medic['404-page-image']['url'] != '') : ?>
                    <img data-aos="fade-up" data-aos-duration="800" src="<?php echo esc_url( $medic['404-page-image']['url'] ); ?>" alt="Image">
                <?php endif; ?>
				<?php if( isset($medic['404-page-text'][0]) && $medic['404-page-text'][0] ) : ?>
                    <h3 data-aos="fade-up" data-aos-duration="1000"><?php echo esc_html( $medic['404-page-text'][0] ); ?></h3>
                <?php endif; ?>
				<?php if( isset($medic['404-page-text'][1]) && $medic['404-page-text'][1] ) : ?>
                    <p data-aos="fade-up" data-aos-duration="1200"><?php echo esc_html( $medic['404-page-text'][1] ); ?></p>
                <?php endif; ?>
                <?php if( isset($medic['404-page-text'][2]) && $medic['404-page-text'][2] ) : ?>
                    <p data-aos="fade-up" data-aos-duration="1400"><?php echo esc_html( $medic['404-page-text'][2] ); ?></p>
                <?php endif; ?>
                <?php if( isset($medic['404-page-text'][3]) && $medic['404-page-text'][3] ) : ?>
                    <p data-aos="fade-up" data-aos-duration="1600"><?php echo esc_html( $medic['404-page-text'][3] ); ?></p>
                <?php endif; ?>
                <div data-aos="fade-up" data-aos-duration="1800" class="search-form">
					<?php get_search_form(); ?>
				</div>
				<a data-aos="fade-up" data-aos-duration="2000" href="<?php echo esc_url(home_url('/')); ?>" class="medic-default-btn page-btn active">
					<?php if(isset($medic['homepage-text']) && $medic['homepage-text'] != '') : ?>
	                    <?php echo esc_html( $medic['homepage-text'] ); ?>
	                <?php endif; ?>
				</a>
			</div>
		</div>
		<!-- End 404 Error Page -->

	</main><!-- #main -->

<?php

get_footer();
