<?php


function medic_add_style_script_to_head() { ?>
	<style type="text/css">
        <?php global $medic; ?> 
		<?php echo esc_attr( $medic['custom-css'] ); ?>
        body {
            background-color: <?php echo esc_attr( $medic['body-background']['background-color'] ); ?>;
            background-repeat: <?php echo esc_attr( $medic['body-background']['background-repeat'] ); ?>;
            background-size: <?php echo esc_attr( $medic['body-background']['background-size'] ); ?>;
            background-attachment: <?php echo esc_attr( $medic['body-background']['background-attachment'] ); ?>;
            background-position: <?php echo esc_attr( $medic['body-background']['background-position'] ); ?> !important;
            background-image: url( <?php echo esc_url( $medic['body-background']['background-image'] ); ?> );
        }
        .bg-color, .single-shop, .form-control, input[type="search"],
        input[type="text"], input[type="email"], input[type="url"], 
        input[type="password"], input[type="number"], input[type="tel"], 
        input[type="range"], input[type="date"], input[type="month"], 
        input[type="week"], input[type="time"], input[type="datetime"], 
        input[type="datetime-local"], input[type="color"], textarea, 
        .appointment-here-form .nice-select, .appointment-here-form select, 
        .contact-form form input, .contact-form form textarea, .single-counter i, 
        .about-content ul li i, .single-services i, .single-shop .purchase-bar {
            background-color: <?php echo esc_attr( $medic['bg-color'] ); ?>;
        }
        .site-main .page .page-title-area, .archive.woocommerce-shop .page-title-area {
            background-color: <?php echo esc_attr( $medic['all-page-breadcrumb']['background-color'] ); ?>;
            background-repeat: <?php echo esc_attr( $medic['all-page-breadcrumb']['background-repeat'] ); ?>;
            background-size: <?php echo esc_attr( $medic['all-page-breadcrumb']['background-size'] ); ?>;
            background-attachment: <?php echo esc_attr( $medic['all-page-breadcrumb']['background-attachment'] ); ?>;
            background-position: <?php echo esc_attr( $medic['all-page-breadcrumb']['background-position'] ); ?> !important;
            background-image: url( <?php echo esc_url( $medic['all-page-breadcrumb']['background-image'] ); ?> );
        }
        .site-main .post .page-title-area, .archive.tax-product_cat .page-title-area,
        .archive.tax-product_tag .page-title-area {
            background-color: <?php echo esc_attr( $medic['archive-page-breadcrumb']['background-color'] ); ?>;
            background-repeat: <?php echo esc_attr( $medic['archive-page-breadcrumb']['background-repeat'] ); ?>;
            background-size: <?php echo esc_attr( $medic['archive-page-breadcrumb']['background-size'] ); ?>;
            background-attachment: <?php echo esc_attr( $medic['archive-page-breadcrumb']['background-attachment'] ); ?>;
            background-position: <?php echo esc_attr( $medic['archive-page-breadcrumb']['background-position'] ); ?> !important;
            background-image: url( <?php echo esc_url( $medic['archive-page-breadcrumb']['background-image'] ); ?> );
        }
        .single .site-main .page-title-area, .single.single-product .page-title-area {
            background-color: <?php echo esc_attr( $medic['single-archive-breadcrumb']['background-color'] ); ?>;
            background-repeat: <?php echo esc_attr( $medic['single-archive-breadcrumb']['background-repeat'] ); ?>;
            background-size: <?php echo esc_attr( $medic['single-archive-breadcrumb']['background-size'] ); ?>;
            background-attachment: <?php echo esc_attr( $medic['single-archive-breadcrumb']['background-attachment'] ); ?>;
            background-position: <?php echo esc_attr( $medic['single-archive-breadcrumb']['background-position'] ); ?> !important;
            background-image: url( <?php echo esc_url( $medic['single-archive-breadcrumb']['background-image'] ); ?> );
        }
        .search .site-main .page-title-area {
            background-color: <?php echo esc_attr( $medic['search-page-breadcrumb']['background-color'] ); ?>;
            background-repeat: <?php echo esc_attr( $medic['search-page-breadcrumb']['background-repeat'] ); ?>;
            background-size: <?php echo esc_attr( $medic['search-page-breadcrumb']['background-size'] ); ?>;
            background-attachment: <?php echo esc_attr( $medic['search-page-breadcrumb']['background-attachment'] ); ?>;
            background-position: <?php echo esc_attr( $medic['search-page-breadcrumb']['background-position'] ); ?> !important;
            background-image: url( <?php echo esc_url( $medic['search-page-breadcrumb']['background-image'] ); ?> );
        }
        a, .read-more, .header-area .heading-left-part li a:hover, .header-area .heading-left-part li i, .header-area .heading-right-part li a i, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item a:hover, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item.active a, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item .dropdown-menu li a:hover, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item .dropdown-menu li.active > a, .mobile-nav.mean-container .mean-nav ul li a:hover, .mobile-nav.mean-container .mean-nav ul li a.active, .banner-content span, .about-content .top-title, .about-content ul li i, .single-features i, .single-services i, .choose-tab .tabs li:hover, .choose-tab .tabs li.current, .faq-accordion h2 span, .faq-accordion .accordion .accordion-title.active i::before, .single-blog .blog-content ul li a:hover, .single-blog:hover .blog-content a h3, .single-blog:hover .blog-content .read-more, .single-blog:hover .blog-content .read-more i, .appointment-here-form .top-title, .appointment-here-form .form-group i, .single-widget h3, .widget .widget-title, .widget h2, .single-widget ul li a:hover, .widget ul li a:hover, .single-widget.contact ul li a i, .single-widget.contact ul li i, .footer-bottom-area .copy-right p a, .single-counter i, .single-counter p, .hero-slider-area .slider-item .slider-text .top-title, .hero-slider-area .owl-next i, .hero-slider-area .owl-prev i, .page-title-area .page-title-content ul li a:hover, .page-title-area .page-title-content ul .active, .blog-details-left-area .blog-details-single-post ul li i, .blog-details-left-area .prev-next .next-post i, .blog-details-left-area .prev-next .prev-post i, .blog-details-left-area .blog-details-single-post ul li a i, .blog-details-left-area .blog-details-single-post ul li a:hover, .blog-details-left-area .blog-details-single-post ul li a:hover i, .blog-details-left-area .prev-next .prev-post a:hover, .blog-details-left-area .prev-next .next-post a:hover, .blog-details-right-area .widget_block ul li a:hover, .blog-details-right-area .widget_block ol li a:hover, .blog-details-right-area .widget_block.archives-widget ul li a:hover, .blog-details-right-area .widget_block.archives-widget ul li a:hover span, .blog-details-right-area .widget_block.categories-widget ul li a:hover, .blog-details-right-area .widget_block.categories-widget ul li a:hover span, .contact-info-area .single-contact-info i, .contact-info-area .single-contact-info:hover i, .user-area-style .contact-form-action form .form-condition .agree-label a, .user-area-style .contact-form-action .account-desc a, .user-area-style .contact-form-action .forget, .user-area-style .contact-form-action .now-register a, .error-area .error-content-wrap h1, .video-btn, .section-title .top-title, .section-title h2 span, .woocommerce-info::before, .woocommerce-info::after, .single-shop .shop-content .product-price, .woocommerce ul.products li.product .price, .single-shop .single-shop-cat:hover, .single-shop .shop-content h3:hover, .woocommerce div.product p.price, .woocommerce div.product span.price, .about-content-two .top-title, .get-in-touch ul li i, .get-in-touch ul li span, .get-in-touch ul li a:hover, .contact-form form input::-webkit-input-placeholder, .contact-form form textarea::-webkit-input-placeholder, .contact-form form input::placeholder, .contact-form form textarea::placeholder {
            color: <?php echo esc_attr( $medic['main-color'] ); ?>;
        }
        .header-area .heading-left-part li:hover i, .header-area .heading-right-part li a:hover i, .nav-area .navbar-area .main-nav .navbar .navbar-brand::before, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item a::before, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item .dropdown-menu li a::before, .mean-container .mean-bar, .about-content ul li:hover i, .single-features:hover i, .single-services::before, .single-doctor ul li:hover, .table-condensed .prev:hover, .table-condensed .next:hover, .table-condensed .day:hover, .single-widget .social-area ul li a, .hero-slider-area .owl-next i:hover, .hero-slider-area .owl-prev i:hover, .page-title-area .page-title-content ul li::before, .blog-details-left-area .wp-block-quote::after, .blog-details-right-area .widget_block h2::before, .blog-details-right-area .widget_block.widget_search .wp-block-search label::before, .blog-details-right-area .widget_block.widget_search .wp-block-search button, .blog-details-right-area .widget_block.search-widget .wp-block-search button:hover, .blog-details-right-area .widget_block.tags-widget ul li:hover, .contact-info-area .single-contact-info:hover, .preloader, .go-top, .video-btn:hover, .video-btn:hover::after, .video-btn:hover::before, .pagination-area .page-numbers, .woocommerce ul.products li.product .single-shop .onsale, .woocommerce span.onsale, .woocommerce-pagination-area ul li .page-numbers, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .video-btn::after, .video-btn::before, .video-btn, .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span, .page-template-dark-homepage .owl-theme .owl-dots .owl-dot.active span {
            background-color: <?php echo esc_attr( $medic['main-color'] ); ?>;
        }
        .form-control:focus, input[type="search"]:focus, .nav-area .navbar-area .main-nav nav .navbar-nav .nav-item .dropdown-menu, .single-doctor ul li:hover, .testimonial-area .single-testimonial img, .testimonial-page .single-testimonial img, .faq-accordion .accordion .accordion-content, .single-widget.open-time li, .hero-slider-area .owl-next i, .hero-slider-area .owl-prev i, .blog-details-right-area .widget_block.widget_search .wp-block-search .wp-block-search__input:focus, .woocommerce-info, .woocommerce div.product .woocommerce-tabs ul.tabs li.active a, .woocommerce div.product .woocommerce-tabs ul.tabs li a:hover, .contact-form form input:focus, .contact-form form textarea:focus {
            border-color: <?php echo esc_attr( $medic['main-color'] ); ?>;
        }
        input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="number"]:focus, input[type="tel"]:focus, input[type="range"]:focus, input[type="date"]:focus, input[type="month"]:focus, input[type="week"]:focus, input[type="time"]:focus, input[type="datetime"]:focus, input[type="datetime-local"]:focus, input[type="color"]:focus, textarea:focus, .woocommerce form .form-row.woocommerce-validated .select2-container, .woocommerce form .form-row.woocommerce-validated input.input-text, .woocommerce form .form-row.woocommerce-validated select {
            border-color: <?php echo esc_attr( $medic['main-color'] ); ?>;
        }
        .blog-area.bg-color {
            background-color: <?php echo esc_attr( $medic['blog-page-bg-color'] ); ?>;
        }
        .error-area {
            background-color: <?php echo esc_attr( $medic['404-page-bg-color'] ); ?>;
        }
        .header-area .top-header-area {
            background-color: <?php echo esc_attr( $medic['topbar-bg-color'] ); ?>;
        }
        .header-area .nav-area .navbar-area .main-nav, .mean-container .mean-bar {
            background-color: <?php echo esc_attr( $medic['header-bg-color'] ); ?>;
        }
        .header-area .nav-area .navbar-area .main-nav .navbar .navbar-brand::before {
            background-color: <?php echo esc_attr( $medic['logo-bg-color'] ); ?>;
        }
        .footer-top-area {
            background-color: <?php echo esc_attr( $medic['footer-bg-color'] ); ?>;
        }
        .footer-bottom-area {
            background-color: <?php echo esc_attr( $medic['copyright-bg-color'] ); ?>;
        }
        .subscribe-area {
            background-color: <?php echo esc_attr( $medic['newsletter-bg-color'] ); ?>;
        }
        .medic-default-btn, .medic-default-btn.active::before, button, input[type="button"], input[type="reset"], input[type="submit"], .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .contact-form-area .contact-form form input[type="submit"] {
            background-color: <?php echo esc_attr( $medic['btn-main-color'] ); ?>;
        }
        .contact-form-area .contact-form form input[type="submit"], .contact-form form input[type="submit"]:hover {
            border-color: <?php echo esc_attr( $medic['btn-main-color'] ); ?>;
        }
        .contact-form form input[type="submit"]:hover {
            color: <?php echo esc_attr( $medic['btn-main-color'] ); ?>;
        }
        .medic-default-btn::before, .medic-default-btn.active, button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover {
            background-color: <?php echo esc_attr( $medic['btn-secondary-color'] ); ?>;
        }
	</style>
	<script type="text/javascript">
		<?php echo wp_kses_post( $medic['custom-js'] ); ?>
	</script>

<?php }

add_action( 'wp_head', 'medic_add_style_script_to_head' );
