<?php
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $opt_name = 'medic';

    $theme = wp_get_theme();

    $args = array(
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_title'           => esc_html__( 'Theme Options', 'medic' ),
        'customizer'           => false,
        'admin_bar_priority'   => 50,
        'page_priority'        => 4
    );

    Redux::setArgs( $opt_name, $args );

    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title'    => __('General Options', 'medic'),
        'icon'     => 'el el-dashboard',
        'fields'   => array(
            array(
                'title'   => __('Preloader Show/Hide', 'medic'),
                'type'    => 'radio',
                'id'      => 'preloader-show-hide',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),

                'default' => '1'
            ),

            array(
                'title'   => __('Website Default Layout', 'medic'),
                'type'    => 'radio',
                'id'      => 'website-default-layout',
                'options' => array(
                    '1' => 'LTR',
                    '2' => 'RTL'
                ),

                'default' => '1'
            ),

            array(
                'title'   => __('LTR & RTL Button Show/Hide', 'medic'),
                'type'    => 'radio',
                'id'      => 'ltr-rtl-btn-show-hide',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),

                'default' => '1'
            ),

            array(
               'title'    => __('LTR Button Text', 'medic'),
               'type'     => 'text',
               'id'       => 'ltr-btn-text',
               'default'  => 'LTR'
            ),

            array(
               'title'    => __('RTL Button Text', 'medic'),
               'type'     => 'text',
               'id'       => 'rtl-btn-text',
               'default'  => 'RTL'
            ),

            array(
                'title'     => __('Main Color', 'medic'),
                'subtitle'  => __('Add the main color to your website', 'medic'),
                'type'      => 'color',
                'id'        => 'main-color'
            ),

            array(
                'title'     => __('Background Color', 'medic'),
                'subtitle'  => __('Add the background color to your website', 'medic'),
                'type'      => 'color',
                'id'        => 'bg-color'
            ),

            array(
                'title'     => __('Button Primary Color', 'medic'),
                'subtitle'  => __('Add the button primary color to your website', 'medic'),
                'type'      => 'color',
                'id'        => 'btn-main-color'
            ),

            array(
                'title'     => __('Button Secondary Color', 'medic'),
                'subtitle'  => __('Add the button secondary color to your website', 'medic'),
                'type'      => 'color',
                'id'        => 'btn-secondary-color'
            ),

            array(
                'title'    => __('Body Background', 'medic'),
                'type'    => 'background',
                'id'      => 'body-background',
                'default' => array(
                    'background-color'      => '',
                    'background-repeat'     =>  '',
                    'background-attachment' =>  '',
                    'background-position'   =>  '',
                    'background-size'       =>  ''
                )
            ),

            array(
                'id'          => 'body-typography',
                'type'        => 'typography', 
                'title'       => __('Body Typography', 'medic'),
                'google'      => false,
                'output'      => 'body',
                'units'       =>'px',
                'default'     => array(
                    'color'       => '', 
                    'font-style'  => '', 
                    'font-family' => '', 
                    'font-size'   => '', 
                    'line-height' => ''
                )
            )
        )

    ));

    Redux::setSection( $opt_name, array(
        'title'  => __('Header Options', 'medic'),
        'id'     => 'header',
        'icon'   => 'el el-th',
        'fields' => array(
            array(
                'title'   => __('Top Bar Show/Hide', 'medic'),
                'type'    => 'radio',
                'id'      => 'top-bar-show-hide',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide',
                ),

                'default' => '1'
            ),

            array(
               'title'    => __('Phone Title', 'medic'),
               'type'     => 'text',
               'id'       => 'phone-title',
               'default'  => 'Call Us:'
            ),

            array(
               'title'    => __('Phone', 'medic'),
               'type'     => 'text',
               'id'       => 'phone',
               'default'  => '+464 145 684 325'
            ),

            array(
               'title'    => __('Email Title', 'medic'),
               'type'     => 'text',
               'id'       => 'email-title',
               'default'  => 'Email:'
            ),

            array(
               'title'    => __('Email', 'medic'),
               'type'     => 'text',
               'id'       => 'email',
               'default'  => 'medic@example.com'
            ),

            array(
               'title'    => __('Get Started Button Text', 'medic'),
               'type'     => 'text',
               'id'       => 'get-button-text',
               'default'  => __('Get An Appointment', 'medic')
            ),
            
            array(
               'title'    => __('Get Started Button Link', 'medic'),
               'type'     => 'text',
               'id'       => 'get-button-link',
               'default'  => '#'
            ),

            array(
                'title'     => __('Topbar Background Color', 'medic'),
                'subtitle'  => __('Add background color of the topbar', 'medic'),
                'type'      => 'color',
                'id'        => 'topbar-bg-color'
            ),

            array(
                'title'     => __('Header Background Color', 'medic'),
                'subtitle'  => __('Add background color of the header', 'medic'),
                'type'      => 'color',
                'id'        => 'header-bg-color'
            ),

            array(
                'title'     => __('Logo Background Color', 'medic'),
                'subtitle'  => __('Add background color of the logo', 'medic'),
                'type'      => 'color',
                'id'        => 'logo-bg-color'
            )

          )

        ) 
    );

    Redux::setSection( $opt_name, array(
        'title'    => __('Social Options', 'medic'),
        'icon'     => 'el el-eye-open',
        'fields'   => array(
            array(
                'title'    => __('Social Links', 'medic'),
                'type'     => 'text',
                'id'       => 'social-links',
                'options'  => array(
                    '1'  => 'Facebook',
                    '2'  => 'Twitter',
                    '3'  => 'Youtube',
                    '4'  => 'Linkedin',
                    '5'  => 'Skype',
                    '6'  => 'Instagram',
                    '7'  => 'Pinterest',
                    '8'  => 'GooglePlus'
                )
            ),

            array(
                'title'   => __('Header Social', 'medic'),
                'type'    => 'radio',
                'id'      => 'header-social',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide',
                ),
                'default' => '2'
            )
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'    => __('Blog Options', 'medic'),
        'icon'     => 'el el-website',
        'fields'   => array(
            array(
                'title'     => __('Blog Page Background Color', 'medic'),
                'subtitle'  => __('Add background color of the blog page', 'medic'),
                'type'      => 'color',
                'id'        => 'blog-page-bg-color'
            ),

            array(
                'title'    => __('Blog Page Layout', 'medic'),
                'type'    => 'image_select',
                'id'      => 'blog-page-layout',
                'options'  => array(
                    '1'      => array(
                        'alt'   => '1 Column', 
                        'img'   => ReduxFramework::$_url.'assets/img/1col.png'
                    ),
                    '2'      => array(
                        'alt'   => '2 Column Left', 
                        'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
                    ),
                    '3'      => array(
                        'alt'   => '2 Column Right', 
                        'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
                    )
                ),
                'default' => '1'
            ),

            array(
                'title'    => __('Single Blog Layout', 'medic'),
                'type'    => 'image_select',
                'id'      => 'single-blog-layout',
                'options'  => array(
                    '1'      => array(
                        'alt'   => '1 Column', 
                        'img'   => ReduxFramework::$_url.'assets/img/1col.png'
                    ),
                    '2'      => array(
                        'alt'   => '2 Column Left', 
                        'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
                    ),
                    '3'      => array(
                        'alt'   => '2 Column Right', 
                        'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
                    )
                ),
                'default' => '3'
            ),

            array(
               'title'    => __('Read More Text', 'medic'),
               'type'     => 'text',
               'id'       => 'read-more',
               'default'  => 'Read More'
            ),

            array(
                'title'   => __('Show Share', 'medic'),
                'type'    => 'radio',
                'id'      => 'show-share',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),
                'default' => '1'
            ),

            array(
               'title'    => __('Share Text', 'medic'),
               'type'     => 'text',
               'id'       => 'share-text',
               'default'  => 'Share'
            ),

            array(
                'title'   => __('Show Blog Page Pagination', 'medic'),
                'type'    => 'radio',
                'id'      => 'show-pagination',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),
                'default' => '1'
            ),

            array(
                'title'   => __('Show Single Post Navigation', 'medic'),
                'type'    => 'radio',
                'id'      => 'show-navigation',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),
                'default' => '1'
            ),

            array(
                'title'   => __('Show Single Post Comment', 'medic'),
                'type'    => 'radio',
                'id'      => 'show-comment',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),
                'default' => '1'
            )
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'    => __('Breadcrumb Options', 'medic'),
        'icon'     => 'el el-picture',
        'fields'   => array(
            array(
                'title'   => __('All Pages Breadcrumb', 'medic'),
                'type'    => 'background',
                'id'      => 'all-page-breadcrumb'
            ),

            array(
                'title'   => __('Archive Page Breadcrumb', 'medic'),
                'type'    => 'background',
                'id'      => 'archive-page-breadcrumb'
            ),

            array(
                'title'   => __('Single Archive Breadcrumb', 'medic'),
                'type'    => 'background',
                'id'      => 'single-archive-breadcrumb'
            ),

            array(
                'title'   => __('Serach Page Breadcrumb', 'medic'),
                'type'    => 'background',
                'id'      => 'search-page-breadcrumb'
            )
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'    => __('404 Page', 'medic'),
        'icon'     => 'el el-error',
        'fields'   => array(
            array(
                'title'     => __('404 Page Background Color', 'medic'),
                'subtitle'  => __('Add background color of the 404 page', 'medic'),
                'type'      => 'color',
                'id'        => '404-page-bg-color'
            ),
            
            array(
                'title'    => __('404 Page Text', 'medic'),
                'type'     => 'multi_text',
                'subtitle'  => __('Maximum 4 fields allowed here', 'medic'),
                'id'       => '404-page-text',
            ),

            array(
                'title'    => __('Homepage Text', 'medic'),
                'type'     => 'text',
                'id'       => 'homepage-text',
                'default'  => __('Return To Home', 'medic')
            ),

            array(
                'title'    => __('404 Page Image', 'medic'),
                'type'    => 'media',
                'url'      => true,
                'id'      => '404-page-image'
            )
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'    => __('Newsletter', 'medic'),
        'icon'     => 'el el-envelope',
        'fields'   => array(
            array(
                'title'     => __('Newsletter Area Background Color', 'medic'),
                'subtitle'  => __('Add a background color of newsletter area', 'medic'),
                'type'      => 'color',
                'id'        => 'newsletter-bg-color'
            ),

            array(
                'title'   => __('Show Footer Newsletter', 'medic'),
                'type'    => 'radio',
                'id'      => 'show-newsletter',
                'options' => array(
                    '1' => 'Show',
                    '2' => 'Hide'
                ),
                'default' => '1'
            ),

            array(
                'title'    => __('Newsletter Title', 'medic'),
                'type'     => 'text',
                'id'       => 'newsletter-title',
                'default'  => __('Subscribe Now', 'medic')
            ),

            array(
                'title'    => __('Newsletter Description', 'medic'),
                'subtitle' => __('This field supports all HTML tag', 'medic'),
                'type'     => 'textarea',
                'id'       => 'newsletter-desc',
                'default'  => __('Get our latest news & update regularly', 'medic')
            ),

            array(
                'title'    => __('Newsletter Form Shortcode', 'medic'),
                'type'     => 'text',
                'id'       => 'newsletter-shortcode',
                'placeholder'  => __('Shortcode', 'medic')
            )

        )
    ));

    Redux::setSection( $opt_name, array(
        'title'  => __('Footer Options', 'medic'),
        'id'     => 'footer',
        'icon'   => 'el el-list-alt',
        'fields' => array(
            array(
                'title'     => __('Footer Area Background Color', 'medic'),
                'subtitle'  => __('Add a background color of footer area', 'medic'),
                'type'      => 'color',
                'id'        => 'footer-bg-color'
            ),

            array(
                'title'     => __('Copyright Area Background Color', 'medic'),
                'subtitle'  => __('Add a background color of copyright area', 'medic'),
                'type'      => 'color',
                'id'        => 'copyright-bg-color'
            ),

            array(
                'title'   => __('Show Automatic Year', 'medic'),
                'type'    => 'checkbox',
                'id'      => 'show-automatic-year',
                'default' => true
            ),

            array(
               'title'    => __('Copyright Text', 'medic'),
               'type'     => 'editor',
               'id'       => 'copyright-text',
               'default'  => __('Copyright Medic - WPTheme. Developed by MhrTheme.', 'medic')
            )

          )

        ) 
    );

    Redux::setSection( $opt_name, array(
        'title'  => __('Custom Editor', 'medic'),
        'id'     => 'custom-editor',
        'icon'   => 'el el-brush',
        'fields' => array(
            array(
                'title'     => __('Custom CSS', 'medic'),
                'subtitle'  => __('Add your own css codes here', 'medic'),
                'type'      => 'ace_editor',
                'id'        => 'custom-css',
                'mode'      => 'css'
            ),

            array(
                'title'     => __('Custom JS', 'medic'),
                'subtitle'  => __('Add your own js codes here', 'medic'),
                'type'      => 'ace_editor',
                'id'        => 'custom-js',
                'mode'      => 'javascript'
            ), 
          )
        ) 
    );

    /*
     *
     * <--- END SECTIONS
     *
     */
