<?php
/**
 * WooCommerce Compatibility File
 *
 * @link https://woocommerce.com/
 *
 * @package Medic
 */

/**
 * WooCommerce setup function.
 *
 * @return void
 */
function medic_woocommerce_setup() {
	add_theme_support(
		'woocommerce',
		array(
			'thumbnail_image_width' => 'auto',
			'single_image_width'    => 'auto',
			'product_grid'          => array(
				'default_rows'    => 3,
				'min_rows'        => 1,
				'default_columns' => 3,
				'min_columns'     => 1,
				'max_columns'     => 6
			),
		)
	);
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'medic_woocommerce_setup' );

/**
 * WooCommerce specific scripts & stylesheets.
 *
 * @return void
 */
function medic_woocommerce_scripts() {
	wp_enqueue_style( 'medic-woocommerce-style', get_template_directory_uri() . '/assets/css/woocommerce.css', array(), _S_VERSION );

	wp_enqueue_style( 'medic-woocommerce-responsive', get_template_directory_uri() . '/assets/css/woocommerce-responsive.css', array(), _S_VERSION );

	$font_path   = WC()->plugin_url() . '/assets/fonts/';
	$inline_font = '@font-face {
			font-family: "star";
			src: url("' . $font_path . 'star.eot");
			src: url("' . $font_path . 'star.eot?#iefix") format("embedded-opentype"),
				url("' . $font_path . 'star.woff") format("woff"),
				url("' . $font_path . 'star.ttf") format("truetype"),
				url("' . $font_path . 'star.svg#star") format("svg");
			font-weight: normal;
			font-style: normal;
		}';

	wp_add_inline_style( 'medic-woocommerce-style', $inline_font );
}
add_action( 'wp_enqueue_scripts', 'medic_woocommerce_scripts' );

/**
 * Disable the default WooCommerce stylesheet.
 *
 * Removing the default WooCommerce stylesheet and enqueing your own will
 * protect you during WooCommerce core updates.
 *
 * @link https://docs.woocommerce.com/document/disable-the-default-stylesheet/
 */
//add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

/**
 * Add 'woocommerce-active' class to the body tag.
 *
 * @param  array $classes CSS classes applied to the body tag.
 * @return array $classes modified to include 'woocommerce-active' class.
 */
function medic_woocommerce_active_body_class( $classes ) {
	$classes[] = 'woocommerce-active';

	return $classes;
}
add_filter( 'body_class', 'medic_woocommerce_active_body_class' );

/**
 * Related Products Args.
 *
 * @param array $args related products args.
 * @return array $args related products args.
 */
function medic_woocommerce_related_products_args( $args ) {
	$defaults = array(
		'posts_per_page' => 3,
		'columns'        => 3
	);

	$args = wp_parse_args( $defaults, $args );

	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'medic_woocommerce_related_products_args' );

/**
 * Remove default WooCommerce wrapper.
 */
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );

if ( ! function_exists( 'medic_woocommerce_wrapper_before' ) ) {
	/**
	 * Before Content.
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function medic_woocommerce_wrapper_before() {
		?>  
		    <!-- START PAGE TITLE AREA -->
			<div class="page-title-area">
				<div class="container">
					<div class="page-title-content">
						<h2>
						<?php 
							if(is_single()) :
							    the_title();
							else:
								woocommerce_page_title();
							endif; 
						?>
					    </h2>
						<ul>
							<li>
								<a href="<?php echo esc_url(home_url('/')); ?>">
									<?php echo esc_html('Home', 'medic'); ?>
								</a>
							</li>
							<?php if(is_single()) : ?>
								<li>
									<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>">
									<?php 
										woocommerce_page_title(); 
									?>
									</a>
							    </li>
							<?php elseif(is_product_category()) : ?>
								<li>
									<?php 
										echo esc_html('Category', 'medic'); 
									?>
							    </li>
							<?php elseif(is_product_tag()) : ?>
								<li>
									<?php 
										echo esc_html('Tag', 'medic'); 
									?>
							    </li>
						    <?php endif; ?>
							<li class="active">
								<?php 
									if(is_single()) :
									    the_title();
									else:
										woocommerce_page_title();
									endif; 
								?>
						    </li>
						</ul>
					</div>
				</div>
			</div>
			<!-- END PAGE TITLE AREA -->
			<main id="primary" class="site-main ptb-70">
				<div class="container">
		<?php
	}
}
add_action( 'woocommerce_before_main_content', 'medic_woocommerce_wrapper_before' );

if ( ! function_exists( 'medic_woocommerce_wrapper_after' ) ) {
	/**
	 * After Content.
	 *
	 * Closes the wrapping divs.
	 *
	 * @return void
	 */
	function medic_woocommerce_wrapper_after() {
		?>      </div>
			</main><!-- #main -->
		<?php
	}
}
add_action( 'woocommerce_after_main_content', 'medic_woocommerce_wrapper_after' );

/**
 * Sample implementation of the WooCommerce Mini Cart.
 *
 * You can add the WooCommerce Mini Cart to header.php like so ...
 *
	<?php
		if ( function_exists( 'medic_woocommerce_header_cart' ) ) {
			medic_woocommerce_header_cart();
		}
	?>
 */

if ( ! function_exists( 'medic_woocommerce_cart_link_fragment' ) ) {
	/**
	 * Cart Fragments.
	 *
	 * Ensure cart contents update when products are added to the cart via AJAX.
	 *
	 * @param array $fragments Fragments to refresh via AJAX.
	 * @return array Fragments to refresh via AJAX.
	 */
	function medic_woocommerce_cart_link_fragment( $fragments ) {
		ob_start();
		medic_woocommerce_cart_link();
		$fragments['a.cart-contents'] = ob_get_clean();

		return $fragments;
	}
}
add_filter( 'woocommerce_add_to_cart_fragments', 'medic_woocommerce_cart_link_fragment' );

if ( ! function_exists( 'medic_woocommerce_cart_link' ) ) {
	/**
	 * Cart Link.
	 *
	 * Displayed a link to the cart including the number of items present and the cart total.
	 *
	 * @return void
	 */
	function medic_woocommerce_cart_link() {
		?>
		<a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e( 'View your shopping cart', 'medic' ); ?>">
			<?php
			$item_count_text = sprintf(
				/* translators: number of items in the mini cart. */
				_n( '%d item', '%d items', WC()->cart->get_cart_contents_count(), 'medic' ),
				WC()->cart->get_cart_contents_count()
			);
			?>
			<span class="amount"><?php echo wp_kses_data( WC()->cart->get_cart_subtotal() ); ?></span> <span class="count"><?php echo esc_html( $item_count_text ); ?></span>
		</a>
		<?php
	}
}

if ( ! function_exists( 'medic_woocommerce_header_cart' ) ) {
	/**
	 * Display Header Cart.
	 *
	 * @return void
	 */
	function medic_woocommerce_header_cart() {
		if ( is_cart() ) {
			$class = 'current-menu-item';
		} else {
			$class = '';
		}
		?>
		<ul id="site-header-cart" class="site-header-cart">
			<li class="<?php echo esc_attr( $class ); ?>">
				<?php medic_woocommerce_cart_link(); ?>
			</li>
			<li>
				<?php
				$instance = array(
					'title' => '',
				);

				the_widget( 'WC_Widget_Cart', $instance );
				?>
			</li>
		</ul>
		<?php
	}
}

/**
 * Change number or products per row to 3
 */
add_filter('loop_shop_columns', 'loop_columns', 999);
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}

/**
 * Change the shop page product image wrap
 */
function replacing_template_loop_product_thumbnail() {
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
    function wc_template_loop_product_replaced_thumb() { ?>
        <div class="shop-img">
        	<div class="shop-img-1">
        	    <?php woocommerce_template_loop_product_thumbnail(); ?>
        	    <div class="shop-img-2">
        	    	<?php woocommerce_template_loop_product_thumbnail(); ?>
        	    </div>
        	</div>
        </div>
    <?php }
    add_action( 'woocommerce_before_shop_loop_item_title', 'wc_template_loop_product_replaced_thumb', 10 );
}
add_action( 'woocommerce_init', 'replacing_template_loop_product_thumbnail');

/**
 * Change the shop page product meta wrap
 */
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 ); 
function custom_woocommerce_template_loop_product_title() { ?>
    <div class="shop-content">
    	<h3><?php the_title(); ?></h3>
		<?php global $post;
		    $terms = get_the_terms( $post->ID, 'product_cat' );
		    if ( $terms ) {
			    foreach ( $terms as $i => $term ) {
			        echo '<a href="' .  esc_url( get_term_link( $term ) ) . '" class="single-shop-cat">';
			        echo esc_attr($term->name);
			        echo '</a>';
			        $count = count($terms);
			        if ($i < $count - 1) echo ", ";  
			    }
		    }
		?>
        <span class="product-price"><?php woocommerce_template_loop_price(); ?></span>
    </div>
    <?php
}
add_action( 'woocommerce_shop_loop_item_title', 'custom_woocommerce_template_loop_product_title', 10 );

/**
 * Change the shop page product add to cart wrap
 */
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
function custom_woocommerce_template_loop_product_add_to_cart() {
    global $product; global $args;
	echo apply_filters(
		'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
		sprintf(
			'<div class="purchase-bar"><a href="%s" data-quantity="%s" class="medic-default-btn" %s>Add to Cart</a></div>',
			esc_url( $product->add_to_cart_url() ),
			esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
			esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
			isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
			esc_html( $product->add_to_cart_text() )
		),
		$product,
		$args
	);
}
add_action( 'woocommerce_after_shop_loop_item', 'custom_woocommerce_template_loop_product_add_to_cart', 10 );

/**
 * Change number of products on the shop page
 */
function new_loop_shop_per_page( $cols ) {
  $cols = 6;
  return $cols;
}
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );

/**
 * Input number script
 */
function medic_add_script_to_footer(){ ?>

	<script>
		jQuery(document).ready(function($){
			$(document).on('click', '.plus-btn', function(e) { // replace '.quantity' with document (without single quote)
				$input = $(this).prev('input.qty');
				var val = parseInt($input.val());
				var step = $input.attr('step');
				step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
				$input.val( val + step ).change();
			});
			$(document).on('click', '.minus-btn',  // replace '.quantity' with document (without single quote)
				function(e) {
				$input = $(this).next('input.qty');
				var val = parseInt($input.val());
				var step = $input.attr('step');
				step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
				if (val > 0) {
					$input.val( val - step ).change();
				}
			});
		});
	</script>

	<?php
}
add_action( 'wp_footer', 'medic_add_script_to_footer' );
