<?php
/**
 * The template for displaying search results pages
 *
 * @package Medic
 */

get_header(); ?>

	<main id="primary" class="site-main">

		<?php if ( have_posts() ) : ?>

			<!-- START PAGE TITLE AREA -->
			<div class="page-title-area">
				<div class="container">
					<div class="page-title-content">
						<h2><?php
							/* translators: %s: search query. */
							printf( esc_html__( 'Search Results for: %s', 'medic' ), '<span>' . get_search_query() . '</span>' );
							?>	
						</h2>
						<ul>
							<li>
								<a href="<?php echo esc_url(home_url('/')); ?>">
									<?php echo esc_html('Home', 'medic'); ?>
								</a>
							</li>
							<li class="active"><?php echo get_search_query(); ?></li>
						</ul>
					</div>
				</div>
			</div>
			<!-- END PAGE TITLE AREA -->

			<div class="container ptb-70">

				<?php
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();

					/**
					 * Run the loop for the search to output the results.
					 * If you want to overload this in a child theme then include a file
					 * called content-search.php and that will be used instead.
					 */
					get_template_part( 'template-parts/content', 'search' );

				endwhile;

				the_posts_navigation(); ?>

			</div>

		<?php else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

	</main><!-- #main -->

<?php 

get_footer();
