<?php

/**
 * Template part for displaying page full width content
 *
 * @package Medic
 */

/*

Template Name: Medic Full Width

*/

get_header(); ?>

	<main id="primary" class="site-main">

		<?php

		while ( have_posts() ) : the_post(); ?>
            
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	
				<?php if ( ! is_home() && ! is_front_page() ) : ?>
					<!-- START PAGE TITLE AREA -->
					<div class="page-title-area">
						<div class="container">
							<div class="page-title-content">
								<h2><?php single_post_title(); ?></h2>
								<ul>
									<li>
										<a href="<?php echo esc_url(home_url('/')); ?>">
											<?php echo esc_html('Home', 'medic'); ?>
										</a>
									</li>
									<li class="active"><?php single_post_title(); ?></li>
								</ul>
							</div>
						</div>
					</div>
					<!-- END PAGE TITLE AREA -->
			    <?php endif; ?>

				<?php medic_post_thumbnail(); ?>

				<div class="entry-content">
					<?php
					the_content();

					wp_link_pages(
						array(
							'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'medic' ),
							'after'  => '</div>',
						)
					);
					?>
				</div><!-- .entry-content -->

			</article><!-- #post-<?php the_ID(); ?> -->
			

		<?php endwhile; // End of the loop.
		?>

	</main><!-- #main -->

<?php 

get_footer();
