<?php

add_action( 'add_meta_boxes', 'medic_department_custom_meta_box' );

if( ! function_exists('medic_department_custom_meta_box') ) :

    function medic_department_custom_meta_box($post){

        add_meta_box('add_meta_box_department_icon', __('Select Department Icon', 'medic-extension'), 'medic_department_custom_element_grid_class_meta_box_icon', 'medic-departments', 'normal' , 'high');
    }

endif;

add_action('save_post', 'medic_department_save_metabox');

if( ! function_exists('medic_department_save_metabox') ) :

    function medic_department_save_metabox(){
        global $post;
        if(isset($_POST["custom_element_grid_class_medic_department_icon"])){
            $meta_element_class_doc_icon_new_class = sanitize_text_field($_POST['custom_element_grid_class_medic_department_icon']);
            update_post_meta($post->ID, 'custom_element_grid_class_meta_box_icon_new', $meta_element_class_doc_icon_new_class);
        }
    }

endif;

function medic_department_custom_element_grid_class_meta_box_icon($post){
    $medic_department_meta_element_class_icon = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_icon_new', true);
    $all_icons = medic_extension_department_icons(); ?>
    <select style="min-width: 25%;" name="custom_element_grid_class_medic_department_icon" id="custom_element_grid_class_medic_department_icon">
        <option>
            <?php echo esc_html('Select', 'medic-extension'); ?>
        </option>
        <?php foreach( $all_icons as $icon ) :
            $single_icon = $icon; ?>
            <option value="<?php echo __( $single_icon ); ?>" <?php selected( $medic_department_meta_element_class_icon, $single_icon ); ?> >
                <?php echo __( $icon );
                ?>
            </option>
        <?php endforeach; ?>
    </select>
<?php }
