<?php

add_action( 'add_meta_boxes', 'medic_extension_custom_meta_box_department' );

if( ! function_exists('medic_extension_custom_meta_box_department') ) :

    function medic_extension_custom_meta_box_department($post){
        add_meta_box('add_meta_box_single_department', __('Select Sidebar', 'medic-extension'), 'medic_extension_custom_element_grid_class_meta_box_single_department', 'medic-departments', 'normal' , 'high');
    }

endif;

add_action('save_post', 'medic_extension_save_metabox_department');

if( ! function_exists('medic_extension_save_metabox_department') ) :

    function medic_extension_save_metabox_department(){ 
        global $post;
        if(isset($_POST["custom_element_grid_class_single_department"])){
            $meta_element_class_single_department = sanitize_text_field($_POST['custom_element_grid_class_single_department']);
            update_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_department', $meta_element_class_single_department);
        }
    }

endif;

function medic_extension_custom_element_grid_class_meta_box_single_department($post){
    $meta_element_class_single_department = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_department', true); ?>   
    <label><?php echo esc_html__('Choose the type of the department : ', 'medic-extension'); ?></label>
    <select name="custom_element_grid_class_single_department" id="custom_element_grid_class_single_department">
        <option value="left-sidebar" <?php selected( $meta_element_class_single_department, 'left-sidebar' ); ?>><?php echo esc_html__('Left Sidebar', 'medic-extension'); ?></option>
        <option value="right-sidebar" <?php selected( $meta_element_class_single_department, 'right-sidebar' ); ?>><?php echo esc_html__('Right Sidebar', 'medic-extension'); ?></option>
        <option value="no-sidebar" <?php selected( $meta_element_class_single_department, 'no-sidebar' ); ?>><?php echo esc_html__('No Sidebar', 'medic-extension'); ?></option>
    </select>
  <?php
}
