<?php

/**
 * Elementor Blog Widget.
 *
 * @since 1.1
 */

class Medic_Blog_Widget extends \Elementor\Widget_Base {

	public function get_name() {
        return 'blog';
    }

	public function get_title() {
        return __( 'Blog', 'medic-extension' );
    }

	public function get_icon() {
        return 'eicon-posts-grid';
    }

	public function get_categories() {
        return [ 'medic-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Section Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'section_subtitle',
            [
                'label' => __( 'Section Subtitle', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Subtitle', 'medic-extension' ),
                'default'  => __( 'News', 'medic-extension' )
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Our Latest News', 'medic-extension' )
            ]
        );

        $this->add_control(
            'section_desc',
            [
                'label' => __( 'Section Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'blog_content',
			[
				'label' => esc_html__( 'Blog Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
        );

        $this->add_control(
            'blog_item_style',
            [
                'label' => __( 'Select Blog Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'grid' => __( 'Grid', 'medic-extension' ),
                    'slider' => __( 'Slider', 'medic-extension' )
                ],
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'blog_sidebar',
            [
                'label' => __( 'Select Blog Sidebar', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'input_type' => 'SELECT',
                'options' => [
                    'no-sidebar' => __( 'No Sidebar', 'medic-extension' ),
                    'left-sidebar' => __( 'Left Sidebar', 'medic-extension' ),
                    'right-sidebar' => __( 'Right Sidebar', 'medic-extension' )
                ],
                'default' => 'no-sidebar'
            ]
        );

        $this->add_control(
            'blog_item_column',
            [
                'label' => __( 'Select Blog Column', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'column-1' => __( '1', 'medic-extension' ),
                    'columns-2' => __( '2', 'medic-extension' ),
                    'columns-3' => __( '3', 'medic-extension' )
                ],
                'default' => 'columns-3',
                'condition' => [
                    'blog_item_style' => 'grid'
                ]
            ]
        );

        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => medic_get_blog_cat_list()
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Blog Order By', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'DESC'      => __( 'DESC', 'medic-extension' ),
                    'ASC'       => __( 'ASC', 'medic-extension' )
                ],
                'default' => 'DESC'
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => __( 'Count', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3
            ]
        );

        $this->add_control(
            'meta_desc',
            [
                'label' =>  __( 'Post Info', 'medic-extension' ),
                'type' =>  \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1'   => __( 'Show', 'medic-extension' ),
                    '2'   => __( 'Hide', 'medic-extension' ),
                ],
                'default' => '1',
            ]
        );

        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More Button', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default'   => __('Read More', 'medic-extension')
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_content',
            [
                'label' => esc_html__( 'Button Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' 	=> esc_html__( 'Button Text', 'medic-extension' ),
                'type' 		=> \Elementor\Controls_Manager::TEXT,
                'default' 	=> __('View All Posts', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'medic-extension' ),
                'type' 			=> \Elementor\Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'medic-extension' ),
                    '2' 	=> esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'medic-extension' ),
                'type' 			=> \Elementor\Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display(); ?>

        <!-- Blog Column Style -->
        <?php if($settings['blog_item_style'] == 'grid') : 
            if( $settings['blog_item_column'] == 'column-1' ) :
                $blog_column = 'col-lg-12 col-md-6 col-sm-12'; 
            elseif( $settings['blog_item_column'] == 'columns-2' ) :
                $blog_column = 'col-lg-6 col-md-6 col-sm-12';
            elseif( $settings['blog_item_column'] == 'columns-3' ) :
                $blog_column = 'col-lg-4 col-md-6 col-sm-12';
            endif; 
        endif; ?>
        
        <!-- Blog Button Link -->
        <?php if($settings['btn_link_type'] == '2') : 
            $target = $settings['btn_ex_link']['is_external'] ? ' target="_blank"' : '';
            $nofollow = $settings['btn_ex_link']['nofollow'] ? ' rel="nofollow"' : ''; 
        elseif($settings['btn_link_type'] == '1') : 
            $target = '';
            $nofollow = '';
        endif; 

        // Blog Query
        if( $settings['cat_name'] != '' ) {
            $args = array(
                'post_type'         => 'post',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'category',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        }

        else {
            $args = array(
                'post_type'         => 'post',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order']
            );
        }

        $post_array = new \WP_Query( $args );

        // Get Button Link
        if($settings['show_btn'] == 'yes') {
            if($settings['btn_link_type'] == 1) {
                $btn_link = get_page_link( $settings['btn_link_to_page'] );
            } else {
                $btn_link = $settings['btn_ex_link']['url'];
            }
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title', 'none'); ?>
        
        <!-- START BLOG AREA -->
        <section class="blog-area ptb-70">
            <div class="container"> 
                <?php if($settings['section_subtitle'] != '' || $settings['section_title'] != '' || $settings['section_desc'] != '') : ?> 
                    <div data-aos="fade-up" data-aos-duration="800" class="section-title">
                        <span class="top-title"><?php echo esc_html($settings['section_subtitle']); ?></span>
                        <h2><?php echo esc_html($settings['section_title']); ?></h2>
                        <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                    </div>
                <?php endif; ?>
                <?php if($settings['blog_sidebar'] == 'left-sidebar' || $settings['blog_sidebar'] == 'right-sidebar') : ?>
                    <div class="row justify-content-center">
                <?php else: ?>
                    <div class="">
                <?php endif; ?>
                    <?php if($settings['blog_sidebar'] == 'left-sidebar') : ?> 
                        <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-4 col-md-12">
                            <div class="blog-details-right-area blog-left-sidebar">
                                <?php dynamic_sidebar('blog-sidebar'); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($settings['blog_sidebar'] == 'left-sidebar' || $settings['blog_sidebar'] == 'right-sidebar') : ?>
                        <div class="col-lg-8 col-md-12">
                    <?php endif; ?>
                        <?php if($settings['blog_item_style'] == 'grid') : ?>
                            <div class="row">
                        <?php elseif($settings['blog_sidebar'] == 'no-sidebar' && $settings['blog_item_style'] == 'slider') : ?>
                            <div class="blog-wrap owl-carousel owl-theme">
                        <?php elseif($settings['blog_sidebar'] == 'left-sidebar' || $settings['blog_sidebar'] == 'right-sidebar' && $settings['blog_item_style'] == 'slider') : ?>
                            <div class="blog-sidebar-wrap owl-carousel owl-theme">
                        <?php endif; ?>
                            <?php while($post_array->have_posts()): $post_array->the_post(); ?>
                            <?php if($settings['blog_item_style'] == 'grid') : ?>
                                <div data-aos="fade-up" data-aos-duration="1600"class="<?php echo esc_attr( $blog_column ); ?>">
                            <?php elseif($settings['blog_item_style'] == 'slider') : ?>
                                <div class="blog-slider">
                            <?php endif; ?>
                                <div class="single-blog">
                                    <div class="post-image">
                                        <?php if( get_the_post_thumbnail_url() != '' ) : ?>
                                            <a href="<?php the_permalink(); ?>" class="d-block">
                                                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID() ); ?>" alt="Image">
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                    <div class="blog-content">
                                        <?php if( $settings['meta_desc'] == '1' ) : ?>
                                            <ul>
                                                <li>
                                                    <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author(); ?></a>
                                                </li>
                                                <li>
                                                    <?php 
                                                    $archive_year  = get_the_time( 'Y' ); 
                                                    $archive_month = get_the_time( 'm' ); 
                                                    $archive_day   = get_the_time( 'd' ); 
                                                    ?>
                                                    <a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>">
                                                        <?php the_time('d M, Y'); ?>
                                                    </a>
                                                </li>
                                            </ul>
                                        <?php endif; ?>
                                        <a href="<?php the_permalink(); ?>">
                                            <h3><?php the_title(); ?></h3>
                                        </a>
                                        <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), '16', '' )); ?></p>
                                        <?php if( $settings['read_more'] != '' ): ?>
                                            <a href="<?php the_permalink(); ?>" class="read-more">
                                                <?php echo esc_html( $settings['read_more'] ); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                        <?php wp_reset_query(); ?>
                        </div>
                    <?php if($settings['blog_sidebar'] == 'left-sidebar' || $settings['blog_sidebar'] == 'right-sidebar') : ?> 
                            <!-- Button Part Start --> 
                            <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' && $settings['blog_sidebar'] == 'left-sidebar' || $settings['show_btn'] == 'yes' && $settings['button_text'] != '' && $settings['blog_sidebar'] == 'right-sidebar' ): ?>
                                <div data-aos="fade-up" data-aos-duration="1200" class="btn-area text-center">
                                    <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                </div>
                            <?php endif; ?>
                            <!-- Button Part End -->  
                        </div>
                    <?php endif; ?>
                        
                    <!-- Button Part Start --> 
                    <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' && $settings['blog_sidebar'] == 'no-sidebar' ): ?>
                        <div data-aos="fade-up" data-aos-duration="1200" class="btn-area text-center">
                            <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                        </div>
                    <?php endif; ?>
                    <!-- Button Part End -->

                    <?php if($settings['blog_sidebar'] == 'right-sidebar') : ?> 
                        <div data-aos="fade-up" data-aos-duration="1200" data-aos="fade-up" data-aos-duration="1600" class="col-lg-4 col-md-12">
                            <div class="blog-details-right-area blog-right-sidebar">
                                <?php dynamic_sidebar('blog-sidebar'); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>  
            </div>
        </section>
        <!-- END BLOG AREA -->

    <?php

	}

}
