<?php

/**
 * Elementor Contact Widget.
 *
 * @since 1.1
 */

class Medic_Contact_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'contact';
	}

	public function get_title() {
		return __( 'Contact Form 7', 'medic-extension' );
	}

	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	public function get_categories() {
		return [ 'medic-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'contact_info',
			[
				'label' => __( 'Contact Info', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'show_contact_info',
			[
				'label' => __( 'Show Contact Info?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
			]
		);

		$this->add_control(
            'contact_style',
            [
                'label' => __( 'Contact Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style-01' => __( 'Style 01', 'medic-extension' ),
                    'style-02' => __( 'Style 02', 'medic-extension' )
                ],
                'default' => 'style-01'
            ]
        );

        $this->add_control(
			'contact_info_title', [
				'label' => __( 'Contact Info Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => __( 'Title', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'Contact Us', 'medic-extension' ),
				'condition' => [
                    'contact_style' => 'style-02'
                ]
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'icon_type',
			[
				'label' => __( 'Icon Type', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'input_type' => 'SELECT',
				'options' => [
					'general' => __( 'General', 'medic-extension' ),
					'library' => __( 'Library', 'medic-extension' ),
				],
				'default' => 'general'
			]
		);

		$repeater->add_control(
			'single_contact_icon1', [
				'label' => __( 'Icon', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICON,
				'show_label' => true,
				'options' => medic_extension_icons(),
				'default' => 'bx bx-envelope',
				'condition' => [
                    'icon_type' => 'general'
                ]
			]
		);

		$repeater->add_control(
			'single_contact_icon2', [
				'label' => __( 'Icon', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'show_label' => true,
				'default' => [
                    'value' => 'fa fa-envelope',
                    'library' => 'solid'
                ],
                'condition' => [
                    'icon_type' => 'library'
                ]
			]
		);

		$repeater->add_control(
			'single_contact_title', [
				'label' => __( 'Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => __( 'Title', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'Email Us:', 'medic-extension' )
			]
		);

		$repeater->add_control(
			'single_contact_content', [
				'label' => __( 'Content', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Content', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( '<a href="mailto:hello@example.com">hello@example.com</a>', 'medic-extension' )
			]
		);

		$this->add_control(
			'single_contact_info',
			[
				'label' => __( 'Single Contact Info', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'Single Contact #1', 'medic-extension' ),
						'list_content' => __( 'Single Contact Content', 'medic-extension' ),
					],
				
				],
			]
		);

		$this->add_control(
            'contact_info_bg_color',
            [
                'label' => __( 'Contact Info Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '.contact-info-area' => 'background-color: {{VALUE}}'
                ],
                'condition' => [
                    'contact_style' => 'style-01'
                ]
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'contact_section',
			[
				'label' => __( 'Contact Section', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

	    $this->add_control(
			'section_title',
			[
				'label' => __( 'Section Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'Title', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'Drop Us A Message For Any Query', 'medic-extension' )
			]
		);

		$this->add_control(
			'section_desc',
			[
				'label' => __( 'Section Description', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Description', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Sint repellendus molestiae, neque earum magnam enim, magni maiores laudantium ratione libero sapiente eum molestias.', 'medic-extension')
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'contact_form',
			[
				'label' => __( 'Contact Form', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'contact_form_title', [
				'label' => __( 'Contact Form Title', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => __( 'Title', 'medic-extension' ),
				'description' => __('This field supports all HTML tag', 'medic-extension'),
				'default'  => __( 'Drop Us A Message', 'medic-extension' ),
				'condition' => [
                    'contact_style' => 'style-02'
                ]
			]
		);

		$this->add_control(
			'contact_form_type',
			[
				'label' => __( 'Form Type', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'input_type' => 'SELECT',
				'options' => [
					'dropdown' => __( 'Dropdown', 'medic-extension' ),
					'shortcode' => __( 'Shortcode', 'medic-extension' ),
				],
				'default' => 'dropdown'
			]
		);

		$this->add_control(
            'select_contact_form',
            [
                'label' => esc_html__('Select Form', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => medic_get_wpcf7_list(),
                'default' => '0',
                'condition' => [
                    'contact_form_type' => 'dropdown'
                ]
            ]
        );

		$this->add_control(
			'contact_form_shortcode',
			[
				'label' => __( 'Form Shortcode', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'input_type' => 'text',
				'placeholder' => __( 'Shortcode', 'medic-extension' ),
				'condition' => [
                    'contact_form_type' => 'shortcode'
                ]
			]
		);

		$this->add_control(
            'contact_form_bg_color',
            [
                'label' => __( 'Contact Form Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-area' => 'background-color: {{VALUE}}'
                ],
                'condition' => [
                    'contact_style' => 'style-01'
                ]
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'contact_google_map',
			[
				'label' => __( 'Google Map', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
			'show_google_map',
			[
				'label' => __( 'Show Google Map?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
			]
		);

		$this->add_control(
			'contact_google_map_code',
			[
				'label' => __( 'Google Map Embed Code', 'medic-extension' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => __( 'Embed Code', 'medic-extension' ),
				'default' => __( '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3022.9401047993993!2d-73.99173408522613!3d40.74134344375791!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c259a3f79e5b77%3A0x25011fc87ca4dae!2s175%205th%20Ave%2C%20New%20York%2C%20NY%2010010%2C%20USA!5e0!3m2!1sen!2sbd!4v1633785743068!5m2!1sen!2sbd" width="600" height="550" style="border:0;" allowfullscreen="" loading="lazy"></iframe>', 'medic-extension'),
				'condition' => [
                    'show_google_map' => 'yes'
                ]
			]
		);

		$this->add_control(
            'google_map_bg_color',
            [
                'label' => __( 'Google Map Area Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .map-area' => 'background-color: {{VALUE}}'
                ],
                'condition' => [
                    'contact_style' => 'style-01'
                ]
            ]
        );

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); 

		if($settings['contact_style'] == 'style-01') : ?>
        
	        <?php if($settings['show_contact_info'] == 'yes') : ?>
				<!-- START CONTACT INFO AREA -->
				<section class="contact-info-area ptb-70">
					<div class="container">
						<div class="row">
				            <?php foreach ( $settings['single_contact_info'] as $item ) : ?>
		                        <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-4 col-sm-6">
		                        	<div class="single-contact-info">
		                        		<?php if( $item['icon_type'] == 'general' ) : ?>
		                            	    <i class="<?php echo wp_kses_post( $item['single_contact_icon1'] ); ?>"></i>
		                            	<?php else: 
		                            		medic_render_icon( $item, 'icon', 'single_contact_icon2' );
		                            	endif; ?>
			                            <h3>
			                            	<?php echo wp_kses_post($item['single_contact_title']); ?>
			                            </h3>
			                            <?php echo wp_kses_post($item['single_contact_content']); ?>
			                        </div>
		                        </div>
		                    <?php endforeach; ?>
						</div>
					</div>
				</section>
				<!-- START CONTACT INFO AREA -->
		    <?php endif; ?>

			<!-- START CONTACT FORM AREA -->
	        <section data-aos="fade-up" data-aos-duration="1200" class="contact-area pb-70">
	            <div class="container">
	            	<div data-aos="fade-up" data-aos-duration="1600" class="contact-wrap">
	                    <div class="section-title">
	                        <h2><?php echo wp_kses_post($settings['section_title']); ?></h2>
	                        <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
	                    </div>
	                    <?php if($settings['contact_form_type'] == 'dropdown' && !empty($settings['select_contact_form'])) :
	                            echo do_shortcode('[contact-form-7 id="' . $settings['select_contact_form'] . '" ]');
	                    else:
	                        echo do_shortcode($settings['contact_form_shortcode']);
	                    endif; ?>       
		            </div>
	            </div>
	        </section>
	        <!-- END CONTACT FORM AREA -->
	        
	        <?php if($settings['show_google_map'] == 'yes' && $settings['contact_google_map_code'] != '') : ?>
		        <!-- START MAP AREA -->
				<div data-aos="fade-up" data-aos-duration="2000" class="map-area pb-70">
					<div class="container">
						<?php echo __($settings['contact_google_map_code']); ?>
					</div>
				</div>
			    <!-- END MAP AREA -->
		    <?php endif;

	    elseif($settings['contact_style'] == 'style-02') : ?>

	    	<section class="contact-form-area ptb-70">
	            <div class="container">
	                <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
	                    <h2><?php echo wp_kses_post($settings['section_title']); ?></h2>
	                    <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
	                </div>
	                <div class="row">
	                	<?php if($settings['show_contact_info'] == 'yes') : ?>
		                    <div data-aos="fade-up" data-aos-duration="1200" class="col-lg-6">
		                        <div class="get-in-touch">
		                            <h3><?php echo wp_kses_post($settings['contact_info_title']); ?></h3>
		                            <ul>
		                            	<?php foreach ( $settings['single_contact_info'] as $item ) : ?>
			                                <li>
			                                    <div class="icon">
			                                        <?php if( $item['icon_type'] == 'general' ) : ?>
					                            	    <i class="<?php echo wp_kses_post( $item['single_contact_icon1'] ); ?>"></i>
					                            	<?php else: 
					                            		covid_plus_render_icon( $item, 'icon', 'single_contact_icon2' );
					                            	endif; ?>
			                                    </div>
			                                    <span><?php echo wp_kses_post($item['single_contact_title']); ?></span>
			                                    <?php echo wp_kses_post($item['single_contact_content']); ?>
			                                </li>
		                                <?php endforeach; ?>
		                            </ul>
		                            <?php if($settings['show_google_map'] == 'yes' && $settings['contact_google_map_code'] != '') : ?>
								        <!-- START MAP AREA -->
										<div data-aos="fade-up" data-aos-duration="1600" class="contact-map">
											<?php echo __($settings['contact_google_map_code']); ?>
										</div>
									    <!-- END MAP AREA -->
								    <?php endif; ?>
		                        </div>
		                    </div>
	                    <?php endif; ?>
	                    <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-6">
	                        <div class="contact-form">
	                            <h3><?php echo wp_kses_post($settings['contact_form_title']); ?></h3>
	                            <?php if($settings['contact_form_type'] == 'dropdown' && !empty($settings['select_contact_form'])) :
			                            echo do_shortcode('[contact-form-7 id="' . $settings['select_contact_form'] . '" ]');
			                    else:
			                        echo do_shortcode($settings['contact_form_shortcode']);
			                    endif; ?>
	                        </div>               
	                    </div>
	                </div>
	            </div>
	        </section>

	    <?php endif;

    }

}
