<?php

/**
 * Elementor Department Widget.
 *
 * @since 1.1
 */

class Medic_Department_Widget extends \Elementor\Widget_Base {

	public function get_name() {
        return 'department';
    }

	public function get_title() {
        return __( 'Department', 'medic-extension' );
    }

	public function get_icon() {
        return 'eicon-posts-group';
    }

	public function get_categories() {
        return [ 'medic-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Section Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'section_subtitle',
            [
                'label' => __( 'Section Subtitle', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Subtitle', 'medic-extension' ),
                'default'  => __( 'Our Departments', 'medic-extension' )
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default'  => __( 'Our Healthcare <span>Departments</span>', 'medic-extension' )
            ]
        );

        $this->add_control(
            'section_desc',
            [
                'label' => __( 'Section Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default' => __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Labore perferendis deleniti illum necessitati voluptates ipsum, ratione dolorum veritatis minus mollitia placeat.', 'medic-extension')
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'department_content',
			[
				'label' => esc_html__( 'Department Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
        );

        $this->add_control(
            'department_item_style',
            [
                'label' => __( 'Select Department Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'grid' => __( 'Grid', 'medic-extension' ),
                    'slider' => __( 'Slider', 'medic-extension' )
                ],
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'department_item_column',
            [
                'label' => __( 'Select Department Column', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'column-1' => __( '1', 'medic-extension' ),
                    'columns-2' => __( '2', 'medic-extension' ),
                    'columns-3' => __( '3', 'medic-extension' ),
                    'columns-4' => __( '4', 'medic-extension' )
                ],
                'default' => 'columns-3',
                'condition' => [
                    'department_item_style' => 'grid'
                ]
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Department Order By', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'DESC'      => __( 'DESC', 'medic-extension' ),
                    'ASC'       => __( 'ASC', 'medic-extension' )
                ],
                'default' => 'DESC'
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => __( 'Count', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6
            ]
        );

        $this->add_control(
            'read_more',
            [
                'label' => __( 'Read More Button', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default'   => __('Read More', 'medic-extension')
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'department_item_style' => 'grid'
                ]
            ]
        );

        $this->add_control(
            'show_featured_img',
            [
                'label' => __( 'Show Featured Image?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );

        $this->add_control(
            'department_bg_color',
            [
                'label' => __( 'Department Background Color', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-services' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_content',
            [
                'label' => esc_html__( 'Button Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'yes'
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button Text', 'medic-extension' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => __('View All Departments', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type',
            [
                'label'         => esc_html__( 'Button Link Type', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options' => [
                    '1'     => esc_html__( 'Link To Page', 'medic-extension' ),
                    '2'     => esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page',
            [
                'label'         => esc_html__( 'Button Link Page', 'medic-extension' ),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'label_block'   => true,
                'options'       => medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link',
            [
                'label'     => esc_html__('Button External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display(); ?>

        <!-- Department Column Style -->
        <?php if($settings['department_item_style'] == 'grid') : 
            if( $settings['department_item_column'] == 'column-1' ) :
                $department_column = 'col-lg-12 col-md-6 col-sm-12'; 
            elseif( $settings['department_item_column'] == 'columns-2' ) :
                $department_column = 'col-lg-6 col-md-6 col-sm-12';
            elseif( $settings['department_item_column'] == 'columns-3' ) :
                $department_column = 'col-lg-4 col-md-6 col-sm-12';
            elseif( $settings['department_item_column'] == 'columns-4' ) :
                $department_column = 'col-lg-3 col-md-6 col-sm-12';
            endif; 
        endif;

        // Department Query
        $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
        $args = array(
            'post_type'         => 'medic-departments',
            'posts_per_page'    => $settings['count'],
            'order'             => $settings['order'],
            'paged' => $paged
        );

        $post_array = new \WP_Query( $args );

        // Inline Editing
        $this-> add_inline_editing_attributes('title', 'none'); ?>
        
        <!-- START SERVICES AREA -->
        <section class="services-area ptb-70">
            <div class="container"> 
                <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                    <span class="top-title"><?php echo esc_html($settings['section_subtitle']); ?></span>
                    <h2><?php echo wp_kses_post($settings['section_title']); ?></h2>
                    <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                </div>
                <?php if($settings['department_item_style'] == 'grid') : ?>
                    <div class="row justify-content-center">
                <?php elseif($settings['department_item_style'] == 'slider') : ?>
                    <div class="department-wrap owl-carousel owl-theme">
                <?php endif; ?>
                    <?php while($post_array->have_posts()): $post_array->the_post(); ?>
                    <?php if($settings['department_item_style'] == 'grid') : ?>
                        <div data-aos="fade-up" data-aos-duration="1600" class="<?php echo esc_attr( $department_column ); ?>">
                    <?php elseif($settings['department_item_style'] == 'slider') : ?>
                        <div class="department-slider">
                    <?php endif; ?>
                        <div class="single-services">
                            <?php if( $settings['show_featured_img'] == 'yes' ): ?>
                                <div class="post-image">
                                    <?php if( get_the_post_thumbnail_url() != '' ) : ?>
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php echo get_the_post_thumbnail_url(get_the_ID() ); ?>" alt="Image">
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php
                            global $post; 
                            $medic_department_meta_element_class_icon = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_icon_new', true);
                            if($medic_department_meta_element_class_icon != '') : ?>
                                <i class="flaticon-<?php echo esc_attr($medic_department_meta_element_class_icon); ?>"></i>
                            <?php endif; ?>
                            <h3 class="department-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h3>
                            <p><?php echo esc_html(wp_trim_words( get_the_excerpt(), '20', '' )); ?></p>
                            <?php if( $settings['read_more'] != '' ): ?>
                                <a href="<?php the_permalink(); ?>" class="read-more">
                                    <?php echo esc_html( $settings['read_more'] ); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
                </div>
                
                <!-- Pagination Part Start -->
                <?php if( $settings['show_pagination'] == 'yes' && $settings['department_item_style'] == 'grid' ): ?>
                    <div data-aos="fade-up" data-aos-duration="1600" class="col-lg-12 col-md-12">
                        <div class="pagination-area text-center">
                            <div class="nav-links">
                                <?php 
                                    $medic_paginate = 999999999;
                                    echo paginate_links( array(
                                        'base' => str_replace( $medic_paginate, '%#%', get_pagenum_link( $medic_paginate ) ),
                                        'format' => '?paged=%#%',
                                        'current' => max(1, get_query_var('paged') ),
                                        'total' => $post_array->max_num_pages,
                                        'prev_text' => sprintf('<i class="bx bx-chevrons-left"></i>'),
                                        'next_text' => sprintf('<i class="bx bx-chevrons-right"></i>')
                                    ) ); 
                                ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <!-- Pagination Part End -->

                <!-- Department Button Link -->
                <?php if($settings['btn_link_type'] == '2') : 
                    $target = $settings['btn_ex_link']['is_external'] ? ' target="_blank"' : '';
                    $nofollow = $settings['btn_ex_link']['nofollow'] ? ' rel="nofollow"' : ''; 
                elseif($settings['btn_link_type'] == '1') : 
                    $target = '';
                    $nofollow = '';
                endif;

                // Get Button Link
                if($settings['show_btn'] == 'yes') {
                    if($settings['btn_link_type'] == 1) {
                        $btn_link = get_page_link( $settings['btn_link_to_page'] );
                    } else {
                        $btn_link = $settings['btn_ex_link']['url'];
                    }
                } ?>

                <!-- Button Part Start --> 
                <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' ): ?>
                    <div data-aos="fade-up" data-aos-duration="1200" class="btn-area text-center">
                        <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                    </div>
                <?php endif; ?>
                <!-- Button Part End --> 

            </div>
        </div>
        <!-- END SERVICES AREA -->

    <?php

	}

}
