<?php

/**
 * Elementor Product Widget.
 *
 * @since 1.1
 */

class Medic_Product_Widget extends \Elementor\Widget_Base {

	public function get_name() {
        return 'product';
    }

	public function get_title() {
        return __( 'Products', 'medic-extension' );
    }

	public function get_icon() {
        return 'eicon-products';
    }

	public function get_categories() {
        return [ 'medic-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Section Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => __( 'Section Title', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __( 'Title', 'medic-extension' ),
                'default'  => __( 'Our Featured Products', 'medic-extension' )
            ]
        );

        $this->add_control(
            'section_desc',
            [
                'label' => __( 'Section Description', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Description', 'medic-extension' ),
                'description' => __('This field supports all HTML tag', 'medic-extension'),
                'default' => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incidiunt labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida.', 'medic-extension')
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'product_content',
			[
				'label' => esc_html__( 'Product Content', 'medic-extension' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT
			]
        );

        $this->add_control(
            'product_item_style',
            [
                'label' => __( 'Select Product Style', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'grid' => __( 'Grid', 'medic-extension' ),
                    'slider' => __( 'Slider', 'medic-extension' ),
                    'list' => __( 'List', 'medic-extension' )
                ],
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'product_item_column',
            [
                'label' => __( 'Select Product Column', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'column-1' => __( '1', 'medic-extension' ),
                    'columns-2' => __( '2', 'medic-extension' ),
                    'columns-3' => __( '3', 'medic-extension' ),
                    'columns-4' => __( '4', 'medic-extension' )
                ],
                'default' => 'columns-3',
                'condition' => [
                    'product_item_style' => 'grid'
                ]
            ]
        );

        $this->add_control(
            'cat_name',
            [
                'label' => __( 'Choose Category', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => medic_get_products_cat_list()
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Product Order By', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'DESC'      => __( 'DESC', 'medic-extension' ),
                    'ASC'       => __( 'ASC', 'medic-extension' )
                ],
                'default' => 'DESC'
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => __( 'Count', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' =>  __( 'Show Pagination', 'medic-extension' ),
                'type' =>  \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '1'   => __( 'Show', 'medic-extension' ),
                    '2'   => __( 'Hide', 'medic-extension' )
                ],
                'default' => '2',
                'condition' => [
                    'product_item_style' => array('grid', 'list')
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_content',
            [
                'label' => esc_html__( 'Button Content', 'medic-extension' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => __( 'Show Button?', 'medic-extension' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'medic-extension' ),
                'label_off' => __( 'No', 'medic-extension' ),
                'return_value' => 'yes',
                'default' => 'no'
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' 	=> esc_html__( 'Button Text', 'medic-extension' ),
                'type' 		=> \Elementor\Controls_Manager::TEXT,
                'default' 	=> __('View All Products', 'medic-extension'),
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_type',
            [
                'label' 		=> esc_html__( 'Button Link Type', 'medic-extension' ),
                'type' 			=> \Elementor\Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' => [
                    '1'  	=> esc_html__( 'Link To Page', 'medic-extension' ),
                    '2' 	=> esc_html__( 'External Link', 'medic-extension' ),
                ],
                'default' => '2',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_link_to_page',
            [
                'label' 		=> esc_html__( 'Button Link Page', 'medic-extension' ),
                'type' 			=> \Elementor\Controls_Manager::SELECT,
                'label_block' 	=> true,
                'options' 		=> medic_get_page_as_list(),
                'condition' => [
                    'btn_link_type' => '1',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_ex_link',
            [
                'label'		=> esc_html__('Button External Link', 'medic-extension'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true
                ],
                'condition' => [
                    'btn_link_type' => '2',
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display(); ?>

        <!-- Product Column Style -->
        <?php if($settings['product_item_style'] == 'grid') : 
            if( $settings['product_item_column'] == 'column-1' ) :
                $product_column = 'full-col col-lg-12 col-md-6 col-sm-6'; 
            elseif( $settings['product_item_column'] == 'columns-2' ) :
                $product_column = 'full-col col-lg-6 col-md-6 col-sm-6';
            elseif( $settings['product_item_column'] == 'columns-3' ) :
                $product_column = 'full-col col-lg-4 col-md-6 col-sm-6';
            elseif( $settings['product_item_column'] == 'columns-4' ) :
                $product_column = 'full-col col-xl-3 col-lg-4 col-md-6 col-sm-6';
            endif; 
        endif; ?>
        
        <!-- Product Button Link -->
        <?php if($settings['btn_link_type'] == '2') : 
            $target = $settings['btn_ex_link']['is_external'] ? ' target="_blank"' : '';
            $nofollow = $settings['btn_ex_link']['nofollow'] ? ' rel="nofollow"' : ''; 
        elseif($settings['btn_link_type'] == '1') : 
            $target = '';
            $nofollow = '';
        endif; 

        // Product Query
        if( $settings['cat_name'] != '' ) {
            global $paged;
            $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
            $product_args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'paged'             => $paged,
                'tax_query'         => array(
                    array(
                        'taxonomy'      => 'product_cat',
                        'field'         => 'slug',
                        'terms'         => $settings['cat_name'],
                        'hide_empty'    => false
                    )
                )
            );
        }

        else {
            global $paged;
            $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
            $product_args = array(
                'post_type'         => 'product',
                'posts_per_page'    => $settings['count'],
                'order'             => $settings['order'],
                'paged'             => $paged
            );
        }

        $product_array = new \WP_Query( $product_args );

        // Get Button Link
        if($settings['show_btn'] == 'yes') {
            if($settings['btn_link_type'] == 1) {
                $btn_link = get_page_link( $settings['btn_link_to_page'] );
            } else {
                $btn_link = $settings['btn_ex_link']['url'];
            }
        }

        // Inline Editing
        $this-> add_inline_editing_attributes('title', 'none'); ?>

        <?php if($settings['product_item_style'] == 'grid' || $settings['product_item_style'] == 'slider' ) : ?>
        
            <!-- START PRODUCT AREA -->
            <section class="shop-area woocommerce ptb-70">
                <div class="container"> 
                    <?php if($settings['section_title'] != '' || $settings['section_desc'] != '') : ?> 
                        <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                            <h2><?php echo esc_html($settings['section_title']); ?></h2>
                            <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                        </div>
                    <?php endif; ?>
                        <div>
                            <?php if($settings['product_item_style'] == 'grid') : ?>
                                <div class="row justify-content-center product-grid">
                            <?php elseif($settings['product_item_style'] == 'slider') : ?>
                                <div class="product-slider owl-carousel owl-theme">
                            <?php endif; ?>
                                <?php while($product_array->have_posts()) : $product_array->the_post(); ?>
                                <?php if($settings['product_item_style'] == 'grid') : ?>
                                    <div data-aos="fade-up" data-aos-duration="1600" class="<?php echo esc_attr( $product_column ); ?>">
                                <?php elseif($settings['product_item_style'] == 'slider') : ?>
                                    <div class="product-wrap">
                                <?php endif; ?>
                                    <div class="single-shop">
                                        <?php woocommerce_show_product_sale_flash(); ?>
                                        <?php global $medic;
                                        global $product;
                                        $medic_wc_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );
                                        $medic_wc_placeholder_src = WC()->plugin_url() . '/assets/images/placeholder.png'; ?>
                                        <a href="<?php the_permalink(); ?>">
                                            <div class="shop-img">
                                                <div class="shop-img-1">
                                                    <?php woocommerce_template_loop_product_thumbnail(); ?>
                                                    <div class="shop-img-2">
                                                        <?php woocommerce_template_loop_product_thumbnail(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                        <div class="shop-content">
                                            <a class="product-title" href="<?php the_permalink(); ?>"><h3><?php the_title() ?></h3></a>
                                            <?php global $post;
                                                $terms = get_the_terms( $post->ID, 'product_cat' );
                                                if ( $terms ) {
                                                    foreach ( $terms as $i => $term ) {
                                                        echo '<a href="' .  esc_url( get_term_link( $term ) ) . '" class="single-shop-cat">';
                                                        echo esc_attr($term->name);
                                                        echo '</a>';
                                                        $count = count($terms);
                                                        if ($i < $count - 1) echo ", ";  
                                                    }
                                                }
                                            ?>
                                            <span class="product-price">
                                                <?php woocommerce_template_loop_price(); ?>
                                            </span>
                                        </div>
                                        <div class="purchase-bar">
                                            <?php global $product; global $args;
											echo apply_filters(
												'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
												sprintf(
													'<div class="purchase-bar"><a href="%s" data-quantity="%s" class="medic-default-btn" %s>Add to Cart</a></div>',
													esc_url( $product->add_to_cart_url() ),
													esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
													esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
													isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
													esc_html( $product->add_to_cart_text() )
												),
												$product,
												$args
											); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                            <?php wp_reset_query(); ?>
                            </div>
                            
                            <?php 
                            $total_pages = $product_array->max_num_pages;
                            $total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
                            $current = max(1, get_query_var('paged'));
                            $base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
                            $format  = '/page/%#%';
                            if( $settings['show_pagination'] == 1 ) : ?>
                                <div data-aos="fade-up" data-aos-duration="2000" class="woocommerce-pagination-area text-center">
                                    <?php                                       
                                        $current_page = max(1, get_query_var('paged'));
                                        echo paginate_links(array(
                                            'base'      => $base,
                                            'format'    => $format,
                                            'add_args'  => false,
                                            'current'   => max( 1, $current ),
                                            'total'     => $total_pages,
                                            'prev_text' => '<i class="bx bx-chevrons-left"></i>',
                                            'next_text' => '<i class="bx bx-chevrons-right"></i>',
                                            'type'      => 'list',
                                            'end_size'  => 3,
                                            'mid_size'  => 3
                                        ));
                                    ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Button Part Start --> 
                            <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' ): ?>
                                <div data-aos="fade-up" data-aos-duration="2400" class="btn-area text-center">
                                    <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                                </div>
                            <?php endif; ?>
                            <!-- Button Part End -->

                        </div>

                    </div>  
                </div>
            </section>
            <!-- END PRODUCT AREA -->

        <?php elseif($settings['product_item_style'] == 'list' ) : ?>

            <!-- START PRODUCT AREA -->
            <section class="shop-area woocommerce ptb-70">
                <div class="container"> 
                    <?php if($settings['section_title'] != '' || $settings['section_desc'] != '') : ?> 
                        <div data-aos="fade-up" data-aos-duration="1200" class="section-title">
                            <h2><?php echo esc_html($settings['section_title']); ?></h2>
                            <p><?php echo wp_kses_post($settings['section_desc']); ?></p>
                        </div>
                    <?php endif; ?>

                    <div class="row justify-content-center">
                        <?php while($product_array->have_posts()) : $product_array->the_post(); ?>
                        <div data-aos="fade-up" data-aos-duration="1600" class="product-list full-col">
                            <div class="single-shop row">
                                <?php global $medic;
                                global $product;
                                $medic_wc_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-post-thumbnail' );
                                $medic_wc_placeholder_src = WC()->plugin_url() . '/assets/images/placeholder.png'; ?>
                                <div class="col-lg-4 col-md-12 col-sm-12">
                                    <?php woocommerce_show_product_sale_flash(); ?>
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="shop-img">
                                            <div class="shop-img-1">
                                                <?php woocommerce_template_loop_product_thumbnail(); ?>
                                                <div class="shop-img-2">
                                                    <?php woocommerce_template_loop_product_thumbnail(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div class="col-lg-8 col-md-12 col-sm-12">
                                    <div class="shop-content">
                                        <a class="product-title" href="<?php the_permalink(); ?>"><h3><?php the_title() ?></h3></a>
                                        <?php global $post;
                                            $terms = get_the_terms( $post->ID, 'product_cat' );
                                            if ( $terms ) {
                                                foreach ( $terms as $i => $term ) {
                                                    echo '<a href="' .  esc_url( get_term_link( $term ) ) . '" class="single-shop-cat">';
                                                    echo esc_attr($term->name);
                                                    echo '</a>';
                                                    $count = count($terms);
                                                    if ($i < $count - 1) echo ", ";  
                                                }
                                            }
                                        ?>
                                        <span class="product-price">
                                            <?php woocommerce_template_loop_price(); ?>
                                        </span>
                                    </div>
                                    <div class="purchase-bar">
                                        <?php global $product; global $args;
										echo apply_filters(
											'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
											sprintf(
												'<div class="purchase-bar"><a href="%s" data-quantity="%s" class="medic-default-btn" %s>Add to Cart</a></div>',
												esc_url( $product->add_to_cart_url() ),
												esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
												esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
												isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
												esc_html( $product->add_to_cart_text() )
											),
											$product,
											$args
										); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                        <?php wp_reset_query(); ?>
                    </div>
                    
                    <?php 
                    $total_pages = $product_array->max_num_pages;
                    $total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
                    $current = max(1, get_query_var('paged'));
                    $base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
                    $format  = '/page/%#%';
                    if( $settings['show_pagination'] == 1 ) : ?>
                        <div data-aos="fade-up" data-aos-duration="2000" class="woocommerce-pagination-area text-center">
                            <?php                                       
                                $current_page = max(1, get_query_var('paged'));
                                echo paginate_links(array(
                                    'base'      => $base,
                                    'format'    => $format,
                                    'add_args'  => false,
                                    'current'   => max( 1, $current ),
                                    'total'     => $total_pages,
                                    'prev_text' => '<i class="bx bx-chevrons-left"></i>',
                                    'next_text' => '<i class="bx bx-chevrons-right"></i>',
                                    'type'      => 'list',
                                    'end_size'  => 3,
                                    'mid_size'  => 3
                                ));
                            ?>
                        </div>
                    <?php endif; ?>
                    
                    <!-- Button Part Start --> 
                    <?php if( $settings['show_btn'] == 'yes' && $settings['button_text'] != '' ): ?>
                        <div data-aos="fade-up" data-aos-duration="2400" class="btn-area text-center">
                            <a href="<?php echo esc_url($btn_link); ?>" <?php echo wp_kses_post( $target ); ?> <?php echo wp_kses_post( $nofollow ); ?> class="medic-default-btn"><?php echo esc_html( $settings['button_text'] ); ?></a>
                        </div>
                    <?php endif; ?>
                    <!-- Button Part End -->

                    </div>  
                </div>
            </section>
            <!-- END PRODUCT AREA -->

        <?php endif; ?>

    <?php

	}

}
