<?php

add_action( 'add_meta_boxes', 'medic_extension_custom_meta_box' );

if( ! function_exists('medic_extension_custom_meta_box') ) :

    function medic_extension_custom_meta_box($post){
        add_meta_box('add_meta_box_single_post', __('Select Sidebar', 'medic-extension'), 'medic_extension_custom_element_grid_class_meta_box_single_post', 'post', 'normal' , 'high');
    }

endif;

add_action('save_post', 'medic_extension_save_metabox');

if( ! function_exists('medic_extension_save_metabox') ) :

    function medic_extension_save_metabox(){ 
        global $post;
        if(isset($_POST["custom_element_grid_class_single_post"])){
            $meta_element_class_single_post = sanitize_text_field($_POST['custom_element_grid_class_single_post']);
            update_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_post', $meta_element_class_single_post);
        }
    }

endif;

function medic_extension_custom_element_grid_class_meta_box_single_post($post){
    $meta_element_class_single_post = get_post_meta($post->ID, 'custom_element_grid_class_meta_box_single_post', true); ?>   
    <label><?php echo esc_html__('Choose the type of the post : ', 'medic-extension'); ?></label>
    <select name="custom_element_grid_class_single_post" id="custom_element_grid_class_single_post">
        <option value="default" <?php selected( $meta_element_class_single_post, 'default' ); ?>><?php echo esc_html__('Default', 'medic-extension'); ?></option>
        <option value="no-sidebar" <?php selected( $meta_element_class_single_post, 'no-sidebar' ); ?>><?php echo esc_html__('No Sidebar', 'medic-extension'); ?></option>
        <option value="left-sidebar" <?php selected( $meta_element_class_single_post, 'left-sidebar' ); ?>><?php echo esc_html__('Left Sidebar', 'medic-extension'); ?></option>
        <option value="right-sidebar" <?php selected( $meta_element_class_single_post, 'right-sidebar' ); ?>><?php echo esc_html__('Right Sidebar', 'medic-extension'); ?></option>
    </select>
  <?php
}
