<?php

class medic_contact_us extends WP_Widget {
    public function __construct() {
        parent::__construct('medic_contact_us', __('Medic Contact Us', 'medic-extension'), array(
            'description' => __('This is contact us widget.', 'medic-extension')
        ));
    }
    
    public function widget( $args, $instance ) { ?>
       
        <div class="single-widget contact"> 
            <?php $title = $instance['title']; ?>
            <h3><?php echo esc_attr( $title ); ?></h3>
            <ul>
                <?php $address = $instance['address']; 
                $address_title = $instance['address-title'];
                $email_title = $instance['email-title'];
                $phone_title = $instance['phone-title'];
                if( $address ) : ?>
                    <li>
                        <div class="icon">
                            <i aria-hidden="true" class="bx bx-location-plus"></i>
                        </div>
                        <span><?php echo esc_attr( $address_title ); ?></span>
                        <?php echo esc_attr( $address ); ?>
                    </li>
                <?php endif; 
                $email = $instance['email']; 
                if( $email ) : ?>
                    <li>
                        <div class="icon">
                            <i aria-hidden="true" class="bx bx-envelope"></i>
                        </div>
                        <span><?php echo esc_attr( $email_title ); ?></span>
                        <?php echo esc_attr( $email ); ?></li>
                <?php endif; 
                $phone = $instance['phone']; 
                if( $phone ) : ?>
                    <li>
                        <div class="icon">
                            <i aria-hidden="true" class="bx bx-phone-call"></i>
                        </div>
                        <span><?php echo esc_attr( $phone_title ); ?></span>
                        <?php echo esc_attr( $phone ); ?></li>
                <?php endif; ?>
            </ul>
        </div>                           

    <?php }

    public function form( $instance ) {
        if( isset( $instance['title'] ) ) :
            $title = $instance['title'];
        endif;
        if( isset( $instance['address-title'] ) ) :
            $address_title = $instance['address-title'];
        endif;
        if( isset( $instance['address'] ) ) :
            $address = $instance['address'];
        endif;
        if( isset( $instance['email-title'] ) ) :
            $email_title = $instance['email-title'];
        endif;
        if( isset( $instance['email'] ) ) :
            $email = $instance['email'];
        endif;
        if( isset( $instance['phone-title'] ) ) :
            $phone_title = $instance['phone-title'];
        endif;  
        if( isset( $instance['phone'] ) ) :
            $phone = $instance['phone'];
        endif;                     
    ?>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('title') ); ?>"><?php echo __('Title:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('title') ); ?>" name="<?php echo esc_html( $this->get_field_name('title') ); ?>" value="<?php if( isset( $title ) ) : echo esc_attr( $title ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('address-title') ); ?>"><?php echo __('Address Title:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('address-title') ); ?>" name="<?php echo esc_html( $this->get_field_name('address-title') ); ?>" value="<?php if( isset( $address_title ) ) : echo esc_attr( $address_title ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('address') ); ?>"><?php echo __('Address:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('address') ); ?>" name="<?php echo esc_html( $this->get_field_name('address') ); ?>" value="<?php if( isset( $address ) ) : echo esc_attr( $address ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('email-title') ); ?>"><?php echo __('Email Title:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('email-title') ); ?>" name="<?php echo esc_html( $this->get_field_name('email-title') ); ?>" value="<?php if( isset( $email_title ) ) : echo esc_attr( $email_title ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('email') ); ?>"><?php echo __('Email:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('email') ); ?>" name="<?php echo esc_html( $this->get_field_name('email') ); ?>" value="<?php if( isset( $email ) ) : echo esc_attr( $email ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('phone-title') ); ?>"><?php echo __('Phone Title:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('phone-title') ); ?>" name="<?php echo esc_html( $this->get_field_name('phone-title') ); ?>" value="<?php if( isset( $phone_title ) ) : echo esc_attr( $phone_title ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('phone') ); ?>"><?php echo __('Phone:', 'medic-extension'); ?></label>
    </p>

    <p>
       <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('phone') ); ?>" name="<?php echo esc_html( $this->get_field_name('phone') ); ?>" value="<?php if( isset( $phone ) ) : echo esc_attr( $phone ); endif; ?>">
    </p>

    <?php }
}

function medic_contact_us_function() {
    register_widget('medic_contact_us');
}

add_action('widgets_init', 'medic_contact_us_function');
