<?php

class medic_open_time extends WP_Widget {
    public function __construct() {
        parent::__construct('medic_open_time', __('Medic Open Time', 'medic-extension'), array(
            'description' => __('This is open time widget.', 'medic-extension')
        ));
    }
    
    public function widget( $args, $instance ) { ?>
       
        <div class="single-widget open-time"> 
            <?php $title = $instance['title']; ?>
            <h3><?php echo esc_attr( $title ); ?></h3>
            <ul>
                <?php 
                $day1 = $instance['day1'];
                $time1 = $instance['time1']; 
                if( $day1 || $time1 ) : ?>
                    <li>
                        <span><?php echo esc_attr( $day1 ); ?></span>
                        <span class="right"><?php echo esc_attr( $time1 ); ?></span>
                    </li>
                <?php endif; ?>
                <?php 
                $day2 = $instance['day2'];
                $time2 = $instance['time2']; 
                if( $day2 || $time2 ) : ?>
                    <li>
                        <span><?php echo esc_attr( $day2 ); ?></span>
                        <span class="right"><?php echo esc_attr( $time2 ); ?></span>
                    </li>
                <?php endif; ?>
                <?php 
                $day3 = $instance['day3'];
                $time3 = $instance['time3']; 
                if( $day3 || $time3 ) : ?>
                    <li>
                        <span><?php echo esc_attr( $day3 ); ?></span>
                        <span class="right"><?php echo esc_attr( $time3 ); ?></span>
                    </li>
                <?php endif; ?>
                <?php 
                $day4 = $instance['day4'];
                $time4 = $instance['time4']; 
                if( $day4 || $time4 ) : ?>
                    <li>
                        <span><?php echo esc_attr( $day4 ); ?></span>
                        <span class="right"><?php echo esc_attr( $time4 ); ?></span>
                    </li>
                <?php endif; ?>
                <?php 
                $day5 = $instance['day5'];
                $time5 = $instance['time5']; 
                if( $day5 || $time5 ) : ?>
                    <li>
                        <span><?php echo esc_attr( $day5 ); ?></span>
                        <span class="right"><?php echo esc_attr( $time5 ); ?></span>
                    </li>
                <?php endif; ?>
            </ul>
        </div>                           

    <?php }

    public function form( $instance ) {
        if( isset( $instance['title'] ) ) :
            $title = $instance['title'];
        endif;
        if( isset( $instance['day1'] ) ) :
            $day1 = $instance['day1'];
        endif;
        if( isset( $instance['time1'] ) ) :
            $time1 = $instance['time1'];
        endif;
        if( isset( $instance['day2'] ) ) :
            $day2 = $instance['day2'];
        endif;
        if( isset( $instance['time2'] ) ) :
            $time2 = $instance['time2'];
        endif;
        if( isset( $instance['day3'] ) ) :
            $day3 = $instance['day3'];
        endif;
        if( isset( $instance['time3'] ) ) :
            $time3 = $instance['time3'];
        endif;
        if( isset( $instance['day4'] ) ) :
            $day4 = $instance['day4'];
        endif;
        if( isset( $instance['time4'] ) ) :
            $time4 = $instance['time4'];
        endif;
        if( isset( $instance['day5'] ) ) :
            $day5 = $instance['day5'];
        endif;
        if( isset( $instance['time5'] ) ) :
            $time5 = $instance['time5'];
        endif;                   
    ?>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('title') ); ?>"><?php echo __('Title:', 'medic-extension'); ?></label>
    </p>

    <p>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('title') ); ?>" name="<?php echo esc_html( $this->get_field_name('title') ); ?>" value="<?php if( isset( $title ) ) : echo esc_attr( $title ); endif; ?>">
    </p>

    <br><hr><hr>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('day1') ); ?>"><?php echo __('Day 1:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('day1') ); ?>" name="<?php echo esc_html( $this->get_field_name('day1') ); ?>" value="<?php if( isset( $day1 ) ) : echo esc_attr( $day1 ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('time1') ); ?>"><?php echo __('Time 1:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('time1') ); ?>" name="<?php echo esc_html( $this->get_field_name('time1') ); ?>" value="<?php if( isset( $time1 ) ) : echo esc_attr( $time1 ); endif; ?>">
    </p>

    <br><hr><hr>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('day2') ); ?>"><?php echo __('Day 2:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('day2') ); ?>" name="<?php echo esc_html( $this->get_field_name('day2') ); ?>" value="<?php if( isset( $day2 ) ) : echo esc_attr( $day2 ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('time2') ); ?>"><?php echo __('Time 2:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('time2') ); ?>" name="<?php echo esc_html( $this->get_field_name('time2') ); ?>" value="<?php if( isset( $time2 ) ) : echo esc_attr( $time2 ); endif; ?>">
    </p>

    <br><hr><hr>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('day3') ); ?>"><?php echo __('Day 3:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('day3') ); ?>" name="<?php echo esc_html( $this->get_field_name('day3') ); ?>" value="<?php if( isset( $day3 ) ) : echo esc_attr( $day3 ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('time3') ); ?>"><?php echo __('Time 3:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('time3') ); ?>" name="<?php echo esc_html( $this->get_field_name('time3') ); ?>" value="<?php if( isset( $time3 ) ) : echo esc_attr( $time3 ); endif; ?>">
    </p>

    <br><hr><hr>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('day4') ); ?>"><?php echo __('Day 4:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('day4') ); ?>" name="<?php echo esc_html( $this->get_field_name('day4') ); ?>" value="<?php if( isset( $day4 ) ) : echo esc_attr( $day4 ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('time4') ); ?>"><?php echo __('Time 4:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('time4') ); ?>" name="<?php echo esc_html( $this->get_field_name('time4') ); ?>" value="<?php if( isset( $time4 ) ) : echo esc_attr( $time4 ); endif; ?>">
    </p>

    <br><hr><hr>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('day5') ); ?>"><?php echo __('Day 5:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('day5') ); ?>" name="<?php echo esc_html( $this->get_field_name('day5') ); ?>" value="<?php if( isset( $day5 ) ) : echo esc_attr( $day5 ); endif; ?>">
    </p>

    <P>
        <label for="<?php echo esc_html( $this->get_field_id('time5') ); ?>"><?php echo __('Time 5:', 'medic-extension'); ?></label>
        <input type="text" class="widefat" id="<?php echo esc_html( $this->get_field_id('time5') ); ?>" name="<?php echo esc_html( $this->get_field_name('time5') ); ?>" value="<?php if( isset( $time5 ) ) : echo esc_attr( $time5 ); endif; ?>">
    </p>

    <?php }
}

function medic_open_time_function() {
    register_widget('medic_open_time');
}

add_action('widgets_init', 'medic_open_time_function');
